/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.umd.cs.mtc.MultithreadedTestCase;
import edu.umd.cs.mtc.TestFramework;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConnectableLifecycleManager;

public class MuleAbstractConnectableTestCase {
    static Log log = LogFactory.getLog(MuleAbstractConnectableTestCase.class);

    @Test
    public void testStartRethrowsMuleExceptionCorrectly() throws Exception {
        final MuleException someMuleException = (MuleException)((Object)Mockito.mock(MuleException.class));
        AbstractConnectable connectable = new AbstractConnectable(this.createDummyEndpoint()){

            protected void doStart() throws MuleException {
                throw someMuleException;
            }

            protected WorkManager getWorkManager() {
                return null;
            }

            protected ConnectableLifecycleManager createLifecycleManager() {
                return new ConnectableLifecycleManager("test", (Object)this);
            }
        };
        connectable.initialise();
        connectable.connect();
        try {
            connectable.start();
            Assert.fail((String)("Should have thrown a " + MuleException.class.getSimpleName()));
        }
        catch (MuleException caughtException) {
            this.assertExceptionIsInCaughtException(someMuleException, caughtException);
        }
    }

    @Ignore
    @Test
    public void testStartIsThreadSafe() throws Throwable {
        TestFramework.runOnce((MultithreadedTestCase)new AbstractConnectableMultithreaded());
    }

    private void assertExceptionIsInCaughtException(MuleException someMuleException, MuleException caughtException) {
        boolean found = false;
        for (Throwable candidate = caughtException; candidate != null; candidate = candidate.getCause()) {
            if (!someMuleException.equals((Object)candidate)) continue;
            found = true;
            break;
        }
        if (!found) {
            Assert.fail();
        }
    }

    ImmutableEndpoint createDummyEndpoint() throws Exception {
        ImmutableEndpoint endpoint = (ImmutableEndpoint)Mockito.mock(ImmutableEndpoint.class);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)endpoint.getEndpointURI()).thenReturn((Object)new MuleEndpointURI("http://dummy.endpoint/", muleContext));
        AbstractConnector connector = (AbstractConnector)Mockito.mock(AbstractConnector.class);
        Mockito.when((Object)endpoint.getConnector()).thenReturn((Object)connector);
        RetryPolicyTemplate retryPolicyTemplate = (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class);
        Mockito.when((Object)endpoint.getRetryPolicyTemplate()).thenReturn((Object)retryPolicyTemplate);
        Mockito.when((Object)retryPolicyTemplate.execute((RetryCallback)Matchers.any(RetryCallback.class), (WorkManager)Matchers.any(WorkManager.class))).thenAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                RetryCallback retryCallback = (RetryCallback)invocation.getArguments()[0];
                retryCallback.doWork(null);
                return null;
            }
        });
        return endpoint;
    }

    @Ignore
    static class MethodInvocation {
        private final Thread thread;
        private final String methodName;
        private final MethodPart methodPart;

        public MethodInvocation(Thread thread, String methodName, MethodPart methodPart) {
            this.thread = thread;
            this.methodName = methodName;
            this.methodPart = methodPart;
        }

        public Thread getThread() {
            return this.thread;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public MethodPart getMethodPart() {
            return this.methodPart;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            MethodInvocation other = (MethodInvocation)obj;
            return new EqualsBuilder().append((Object)this.thread, (Object)other.thread).append((Object)this.methodName, (Object)other.methodName).append((Object)this.methodPart, (Object)other.methodPart).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.thread).append((Object)this.methodName).append((Object)this.methodPart).toHashCode();
        }

        public String toString() {
            return "Thread " + this.thread + " passing through " + this.methodName + "() at the " + (Object)((Object)this.methodPart);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Ignore
        static enum MethodPart {
            BEGINNING,
            END;

        }
    }

    @Ignore
    class AbstractConnectableMultithreaded
    extends MultithreadedTestCase {
        private volatile AbstractConnectableForTest connectable;

        AbstractConnectableMultithreaded() {
        }

        public void initialize() {
            try {
                ImmutableEndpoint endpoint = MuleAbstractConnectableTestCase.this.createDummyEndpoint();
                this.connectable = new AbstractConnectableForTest(endpoint);
                this.connectable.initialise();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void thread1() throws Exception {
            this.connectable.start();
        }

        public void thread2() throws Exception {
            this.waitForTick(1);
            this.connectable.start();
        }

        public void finish() {
            for (MethodInvocation methodInvocation : this.connectable.methodInvocations) {
                log.debug((Object)methodInvocation);
            }
            int i = 0;
            AbstractConnectableMultithreaded.assertEquals((String)"doConnect", (String)this.connectable.methodInvocations.get(i++).getMethodName());
            AbstractConnectableMultithreaded.assertEquals((String)"doConnect", (String)this.connectable.methodInvocations.get(i++).getMethodName());
            AbstractConnectableMultithreaded.assertEquals((String)"doStart", (String)this.connectable.methodInvocations.get(i++).getMethodName());
            AbstractConnectableMultithreaded.assertEquals((String)"doStart", (String)this.connectable.methodInvocations.get(i++).getMethodName());
        }

        @Ignore
        class AbstractConnectableForTest
        extends AbstractConnectable {
            private final AtomicBoolean doConnectCalled;
            private final AtomicBoolean doStartCalled;
            List<MethodInvocation> methodInvocations;

            public AbstractConnectableForTest(ImmutableEndpoint endpoint) {
                super(endpoint);
                this.doConnectCalled = new AtomicBoolean();
                this.doStartCalled = new AtomicBoolean();
                this.methodInvocations = new Vector<MethodInvocation>();
            }

            protected WorkManager getWorkManager() {
                return null;
            }

            protected ConnectableLifecycleManager createLifecycleManager() {
                return new ConnectableLifecycleManager("test", (Object)this);
            }

            protected void doConnect() throws Exception {
                this.methodInvocations.add(new MethodInvocation(Thread.currentThread(), "doConnect", MethodInvocation.MethodPart.BEGINNING));
                junit.framework.Assert.assertTrue((boolean)this.doConnectCalled.compareAndSet(false, true));
                junit.framework.Assert.assertFalse((boolean)this.doStartCalled.get());
                AbstractConnectableMultithreaded.this.waitForTick(2);
                junit.framework.Assert.assertFalse((boolean)this.doStartCalled.get());
                this.methodInvocations.add(new MethodInvocation(Thread.currentThread(), "doConnect", MethodInvocation.MethodPart.END));
            }

            protected void doStart() throws MuleException {
                this.methodInvocations.add(new MethodInvocation(Thread.currentThread(), "doStart", MethodInvocation.MethodPart.BEGINNING));
                junit.framework.Assert.assertTrue((boolean)this.doStartCalled.compareAndSet(false, true));
                junit.framework.Assert.assertTrue((boolean)this.doConnectCalled.get());
                this.methodInvocations.add(new MethodInvocation(Thread.currentThread(), "doStart", MethodInvocation.MethodPart.END));
            }
        }
    }
}

