/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.UUID;

public class UUIDTestCase
extends AbstractMuleTestCase {
    public void testGenerateUniqueAndIncrementalIds() throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<Object[]> idsWithIndexes = new ArrayList<Object[]>(1000);
        int numberOfIdsToGenerate = 10000;
        for (int index = 0; index < 10000; ++index) {
            String generatedId = UUID.getAscendingOrderUUID();
            idsWithIndexes.add(new Object[]{generatedId, index});
            if (ids.contains(generatedId)) {
                UUIDTestCase.fail((String)("REPEATED ID :" + index + ": " + generatedId));
                continue;
            }
            ids.add(generatedId);
        }
        Comparator<Object[]> comparatorById = new Comparator<Object[]>(){

            @Override
            public int compare(Object[] o1, Object[] o2) {
                return ((String)o1[0]).compareTo((String)o2[0]);
            }
        };
        Collections.sort(idsWithIndexes, comparatorById);
        for (int index = 0; index < 10000; ++index) {
            UUIDTestCase.assertEquals((Object)index, (Object)((Object[])idsWithIndexes.get(index))[1]);
        }
    }
}

