/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.transport.AbstractMuleMessageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpMuleMessageFactory
extends AbstractMuleMessageFactory {
    public UdpMuleMessageFactory(MuleContext context) {
        super(context);
    }

    @Override
    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{DatagramPacket.class};
    }

    @Override
    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        DatagramPacket packet = (DatagramPacket)transportMessage;
        int length = packet.getLength();
        byte[] payload = new byte[length];
        System.arraycopy(packet.getData(), 0, payload, 0, length);
        return payload;
    }

    @Override
    protected void addProperties(DefaultMuleMessage message, Object transportMessage) throws Exception {
        super.addProperties(message, transportMessage);
        DatagramPacket packet = (DatagramPacket)transportMessage;
        InetAddress address = packet.getAddress();
        if (address != null) {
            message.setOutboundProperty("packet.address", address);
        }
        message.setOutboundProperty("packet.port", packet.getPort());
    }
}

