/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.Map;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.buffer.BoundedFifoBuffer;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelImpl;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.NullPayload;
import org.mule.transport.ajax.BayeuxAware;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

public class AjaxMessageDispatcher
extends AbstractMessageDispatcher
implements BayeuxAware {
    protected AbstractBayeux bayeux;
    protected boolean cacheMessages = false;
    protected int messageCacheSize = 500;
    protected Buffer messageCache;
    protected String channel;
    protected Client client;

    public AjaxMessageDispatcher(OutboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        this.cacheMessages = MapUtils.getBoolean((Map)endpoint.getProperties(), (Object)"cacheMessages", (Boolean)false);
        this.messageCacheSize = MapUtils.getInteger((Map)endpoint.getProperties(), (Object)"messageCacheSize", (Integer)500);
        this.channel = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)this.channel) || this.channel.equals("/")) {
            throw new CreateException(AjaxMessages.createStaticMessage("The subscription path cannot be empty or equal '/'"), (Object)this);
        }
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    protected void doInitialise() throws InitialisationException {
        if (this.cacheMessages) {
            this.messageCache = new BoundedFifoBuffer(this.messageCacheSize);
        }
    }

    protected Client getClient() {
        if (this.client == null) {
            this.client = this.bayeux.newClient(this.channel);
        }
        return this.client;
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (NullPayload.getInstance().equals(event.getMessage().getPayload())) {
            return;
        }
        if (!this.connector.isStarted()) {
            this.logger.warn((Object)("Servlet container has not yet initialised, ignoring event: " + event.getMessage().getPayload()));
            return;
        }
        ChannelImpl chan = this.bayeux.getChannel(this.channel);
        if (chan != null) {
            if (chan.getSubscribers().size() > 0 && this.cacheMessages && !this.messageCache.isEmpty()) {
                while (!this.messageCache.isEmpty()) {
                    for (Client client : chan.getSubscribers()) {
                        this.deliver(client, this.channel, this.messageCache.remove());
                    }
                }
            }
            Object data = event.getMessage().getPayload();
            for (Client client : chan.getSubscribers()) {
                this.deliver(client, this.channel, data);
            }
        } else if (this.cacheMessages) {
            Object data = event.getMessage().getPayload();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("There are no clients waiting, adding message to cache: " + data));
            }
            this.messageCache.add(data);
        }
    }

    protected void deliver(Client client, String channel, Object data) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Delivering to client id: " + client.getId() + " channel:" + channel));
        }
        client.deliver(client, channel, data, null);
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    protected void doDispose() {
        if (this.messageCache != null) {
            this.messageCache.clear();
            this.messageCache = null;
        }
    }
}

