/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.tcp.PollingTcpConnector;
import org.mule.transport.tcp.TcpMessageDispatcher;
import org.mule.transport.tcp.i18n.TcpMessages;
import org.mule.util.MapUtils;

public class PollingTcpMessageReceiver
extends AbstractPollingMessageReceiver {
    private int timeout;
    private PollingTcpConnector connector;

    public PollingTcpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        if (!(connector instanceof PollingTcpConnector)) {
            throw new CreateException(TcpMessages.pollingReceiverCannotbeUsed(), (Object)this);
        }
        this.connector = (PollingTcpConnector)connector;
        this.timeout = MapUtils.getIntValue((Map)endpoint.getProperties(), (Object)"clientSoTimeout", (int)this.connector.getClientSoTimeout());
        if (this.timeout > Integer.MAX_VALUE || this.timeout < 0) {
            throw new IllegalArgumentException("Timeout incorrect: " + this.timeout);
        }
        long pollingFrequency = MapUtils.getLongValue((Map)endpoint.getProperties(), (Object)"pollingFrequency", (long)this.connector.getPollingFrequency());
        if (pollingFrequency > 0L) {
            this.setFrequency(pollingFrequency);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        Socket socket = this.connector.getSocket(this.endpoint);
        try {
            Object result = TcpMessageDispatcher.receiveFromSocket(socket, this.timeout, this.endpoint);
            if (result != null) {
                this.routeMessage(new DefaultMuleMessage(result, this.connector.getMuleContext()));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Routing new message: " + result));
                }
            }
        }
        catch (SocketTimeoutException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + this.endpoint.getEndpointURI()));
            }
        }
        finally {
            this.connector.releaseSocket(socket, this.endpoint);
        }
    }
}

