/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.pool;

import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import java.util.Iterator;
import javax.imageio.spi.ServiceRegistry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.MuleContextAware;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.ClassUtils;

public abstract class ThreadPoolFactory
implements MuleContextAware {
    private static final Log logger = LogFactory.getLog(ThreadPoolFactory.class);
    private static final String PREFERRED_CONFIG_CLASSNAME = "com.mulesoft.mule.config.Preferred";
    private static boolean extensionsAvailable = ClassUtils.isClassOnPath("com.mulesoft.mule.config.Preferred", ThreadPoolFactory.class);
    protected MuleContext muleContext;

    public static ThreadPoolFactory newInstance() {
        Class preferredMarker;
        block6: {
            preferredMarker = null;
            if (extensionsAvailable) {
                try {
                    preferredMarker = ClassUtils.loadClass(PREFERRED_CONFIG_CLASSNAME, ThreadPoolFactory.class);
                }
                catch (ClassNotFoundException e) {
                    extensionsAvailable = false;
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)"Failed to load EE extensions", (Throwable)e);
                }
            }
        }
        Iterator<ThreadPoolFactory> it = ServiceRegistry.lookupProviders(ThreadPoolFactory.class);
        ThreadPoolFactory candidate = null;
        while (it.hasNext()) {
            ThreadPoolFactory threadPoolFactory = it.next();
            if (extensionsAvailable && preferredMarker.isAssignableFrom(threadPoolFactory.getClass())) {
                return threadPoolFactory;
            }
            if (candidate != null) continue;
            candidate = threadPoolFactory;
        }
        if (candidate != null) {
            return candidate;
        }
        throw new MuleRuntimeException(MessageFactory.createStaticMessage("Couldn't find config via SPI mechanism. Corrupted Mule core jar?"));
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public abstract ThreadPoolExecutor createPool(String var1, ThreadingProfile var2);
}

