/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.util.Collections;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;
import org.mule.processor.OptionalAsyncInterceptingMessageProcessor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleFlowConstruct
extends AbstractFlowConstruct {
    protected List<MessageProcessor> messageProcessors = Collections.emptyList();
    protected ThreadingProfile threadingProfile;
    protected WorkManager workManager;

    public SimpleFlowConstruct(String name, MuleContext muleContext) {
        super(name, muleContext);
    }

    @Override
    protected void configureMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        MuleConfiguration config;
        boolean containerMode;
        if (this.threadingProfile == null) {
            this.threadingProfile = this.muleContext.getDefaultServiceThreadingProfile();
        }
        String threadPrefix = (containerMode = (config = this.muleContext.getConfiguration()).isContainerMode()) ? String.format("[%s].flow.%s", config.getId(), this.getName()) : String.format("flow.%s", this.getName());
        builder.chain(new ProcessIfStartedMessageProcessor(this, this.getLifecycleState()));
        builder.chain(new OptionalAsyncInterceptingMessageProcessor(this.threadingProfile, threadPrefix, this.muleContext.getConfiguration().getShutdownTimeout()));
        for (MessageProcessor processor : this.messageProcessors) {
            if (processor instanceof MessageProcessor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
    }

    public ThreadingProfile getThreadingProfile() {
        return this.threadingProfile;
    }

    public void setThreadingProfile(ThreadingProfile threadingProfile) {
        this.threadingProfile = threadingProfile;
    }

    public void setMessageProcessors(List<MessageProcessor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Deprecated
    public void setEndpoint(InboundEndpoint endpoint) {
        this.messageSource = endpoint;
    }
}

