/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.builder;

import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.construct.SimpleFlowConstruct;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.NullMessageProcessor;
import org.mule.processor.builder.InterceptingChainCompositeMessageProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptingChainMessageProcessorBuilder
implements MessageProcessorBuilder {
    protected List processors = new ArrayList();
    protected String name;
    protected FlowConstruct flowConstruct;

    public InterceptingChainMessageProcessorBuilder() {
    }

    public InterceptingChainMessageProcessorBuilder(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    @Override
    public MessageProcessor build() throws MuleException {
        if (this.processors.isEmpty()) {
            return new NullMessageProcessor();
        }
        InterceptingMessageProcessor first = this.createInterceptingMessageProcessor(this.initializeMessageProcessor(this.processors.get(0)));
        InterceptingChainCompositeMessageProcessor composite = new InterceptingChainCompositeMessageProcessor(first, this.processors, this.name);
        InterceptingMessageProcessor current = first;
        for (int i = 1; i < this.processors.size(); ++i) {
            InterceptingMessageProcessor mp = this.createInterceptingMessageProcessor(this.initializeMessageProcessor(this.processors.get(i)));
            current.setListener(mp);
            current = mp;
        }
        return composite;
    }

    protected MessageProcessor initializeMessageProcessor(Object processor) throws MuleException {
        if (processor instanceof MessageProcessorBuilder) {
            return ((MessageProcessorBuilder)processor).build();
        }
        return (MessageProcessor)processor;
    }

    public void setName(String name) {
        this.name = name;
    }

    private InterceptingMessageProcessor createInterceptingMessageProcessor(MessageProcessor processor) {
        if (processor instanceof InterceptingMessageProcessor) {
            return (InterceptingMessageProcessor)processor;
        }
        return new InterceptingMessageProcessorAdapter(processor);
    }

    public InterceptingChainMessageProcessorBuilder chain(MessageProcessor ... processors) {
        for (MessageProcessor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chain(List<MessageProcessor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chainBefore(MessageProcessor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public InterceptingChainMessageProcessorBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    public String toString() {
        if (this.name != null) {
            return "InterceptingChainMessageProcessorBuilder '" + this.name + "'";
        }
        return super.toString();
    }

    class InterceptingMessageProcessorAdapter
    extends AbstractInterceptingMessageProcessor
    implements Disposable {
        private MessageProcessor delegate;

        public InterceptingMessageProcessorAdapter(MessageProcessor mp) {
            this.delegate = mp;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            MuleEvent delegateResult;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Invoking adapted MessageProcessor '" + this.delegate.getClass().getName() + "'"));
            }
            if (this.delegate instanceof OutboundEndpoint) {
                event = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)this.delegate, event.getSession());
            }
            if ((delegateResult = this.delegate.process(event)) != null) {
                return this.processNext(delegateResult);
            }
            if (event.getFlowConstruct() instanceof SimpleFlowConstruct) {
                return this.processNext(OptimizedRequestContext.criticalSetEvent(event));
            }
            return null;
        }

        public void setNext(MessageProcessor next) {
            this.next = next;
        }

        public void dispose() {
            this.delegate = null;
        }

        public String toString() {
            return "InterceptingMessageProcessorAdapter [ target = '" + this.delegate.getClass().getName() + "' ]";
        }
    }
}

