/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.ibeans.api.ClientAnnotationHandler;
import org.ibeans.api.IBeansException;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.Request;
import org.ibeans.api.Response;
import org.ibeans.impl.support.util.TemplateParser;
import org.ibeans.impl.support.util.UriParamFilter;
import org.ibeans.spi.IBeansPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateAnnotationHandler
implements ClientAnnotationHandler {
    private Map<String, String> evals = new HashMap<String, String>();
    protected TemplateParser parser = TemplateParser.createCurlyBracesStyleParser();
    private UriParamFilter filter = new UriParamFilter();
    private IBeansPlugin plugin;

    public TemplateAnnotationHandler(IBeansPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean isMatch(Method method) {
        return this.evals.get(method.toString()) != null;
    }

    public Map<String, String> getEvals() {
        return this.evals;
    }

    public void setEvals(Map<String, String> evals) {
        this.evals = evals;
    }

    @Override
    public Response invoke(InvocationContext ctx) throws Exception {
        String eval = this.evals.get(ctx.getMethod().toString());
        if (eval == null) {
            return null;
        }
        if (eval.length() == 0) {
            return this.createResponse(ctx.getRequest().getPayload(), ctx.getRequest());
        }
        Map<String, Object> props = this.getPropertiesForTemplate(ctx.getRequest());
        eval = this.parser.parse(props, eval);
        eval = this.filter.filterParamsByValue(eval, "null.param");
        Object result = ctx.getExpressionParser().evaluate(eval, ctx.getRequest());
        return this.createResponse(result, ctx.getRequest());
    }

    protected Response createResponse(Object payload, Request request) throws IBeansException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        for (String s : request.getHeaderNames()) {
            headers.put(s, request.getHeader(s));
        }
        HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
        for (String s : request.getAttachmentNames()) {
            attachments.put(s, request.getAttachment(s));
        }
        return this.plugin.createResponse(payload, headers, attachments);
    }

    protected Map<String, Object> getPropertiesForTemplate(Request message) {
        Map props = (Map)message.removeHeader("ibeans.uri.params");
        if (props == null) {
            throw new IllegalStateException("ibeans.uri.params not set on message");
        }
        return props;
    }

    @Override
    public String getScheme(Method method) {
        return "template";
    }
}

