/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfOutboundMessageProcessor;
import org.mule.module.cxf.support.DelegatingOutputStream;
import org.mule.module.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.module.cxf.transport.MuleUniversalTransport;
import org.mule.session.DefaultMuleSession;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;

public class MuleUniversalConduit
extends AbstractConduit {
    private static final Logger LOGGER = LogUtils.getL7dLogger(MuleUniversalConduit.class);
    private EndpointInfo endpoint;
    private CxfConfiguration configuration;
    private Destination decoupledDestination;
    private String decoupledEndpoint;
    private MuleUniversalTransport transport;
    private int decoupledDestinationRefCount;
    private boolean closeInput = true;
    private Map<String, OutboundEndpoint> endpoints = new HashMap<String, OutboundEndpoint>();

    public MuleUniversalConduit(MuleUniversalTransport transport, CxfConfiguration configuration, EndpointInfo ei, EndpointReferenceType t) {
        super(MuleUniversalConduit.getTargetReference(ei, t));
        this.transport = transport;
        this.endpoint = ei;
        this.configuration = configuration;
    }

    public void close(Message msg) throws IOException {
        InputStream in;
        OutputStream os = (OutputStream)msg.getContent(OutputStream.class);
        if (os != null) {
            os.close();
        }
        if (this.closeInput && (in = (InputStream)msg.getContent(InputStream.class)) != null) {
            in.close();
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    public synchronized Destination getBackChannel() {
        if (this.decoupledDestination == null && this.decoupledEndpoint != null) {
            this.setUpDecoupledDestination();
        }
        return this.decoupledDestination;
    }

    protected void setUpDecoupledDestination() {
        EndpointInfo ei = new EndpointInfo();
        ei.setAddress(this.decoupledEndpoint);
        try {
            this.decoupledDestination = this.transport.getDestination(ei);
            this.decoupledDestination.setMessageObserver((MessageObserver)new InterposedMessageObserver());
            this.duplicateDecoupledDestination();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void prepare(final Message message) throws IOException {
        final ByteArrayOutputStream cache = new ByteArrayOutputStream();
        final DelegatingOutputStream delegating = new DelegatingOutputStream(cache);
        message.setContent(OutputStream.class, (Object)delegating);
        message.setContent(DelegatingOutputStream.class, (Object)delegating);
        AbstractPhaseInterceptor<Message> i = new AbstractPhaseInterceptor<Message>("pre-stream"){

            public void handleMessage(Message m) throws Fault {
                try {
                    MuleUniversalConduit.this.dispatchMuleMessage(m);
                }
                catch (IOException e) {
                    throw new Fault((Throwable)e);
                }
            }
        };
        i.getAfter().add(MuleProtocolHeadersOutInterceptor.class.getName());
        message.getInterceptorChain().add((Interceptor)i);
        OutputHandler handler = new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
                out.write(cache.toByteArray());
                delegating.setOutputStream(out);
                message.getInterceptorChain().doIntercept(message);
            }
        };
        MuleEvent event = (MuleEvent)message.getExchange().get((Object)"MULE_EVENT");
        if (event == null) {
            MuleContext muleContext = this.configuration.getMuleContext();
            DefaultMuleMessage muleMsg = new DefaultMuleMessage((Object)handler, muleContext);
            DefaultMuleSession session = new DefaultMuleSession(muleContext);
            String url = this.setupURL(message);
            try {
                OutboundEndpoint ep = this.getEndpoint(muleContext, url);
                event = new DefaultMuleEvent((MuleMessage)muleMsg, (ImmutableEndpoint)ep, (MuleSession)session);
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            event.setTimeout(Integer.MIN_VALUE);
            RequestContext.setEvent((MuleEvent)event);
        } else {
            event.getMessage().setPayload((Object)handler);
        }
        message.getExchange().put((Object)"mule.event", (Object)event);
    }

    protected synchronized OutboundEndpoint getEndpoint(MuleContext muleContext, String uri) throws MuleException {
        if (this.endpoints.get(uri) != null) {
            return this.endpoints.get(uri);
        }
        OutboundEndpoint ndpoint = muleContext.getRegistry().lookupEndpointFactory().getOutboundEndpoint(uri);
        this.endpoints.put(uri, ndpoint);
        return ndpoint;
    }

    protected String setupURL(Message message) throws MalformedURLException {
        int slashIdx;
        String result;
        String value = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        String pathInfo = (String)message.get((Object)Message.PATH_INFO);
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        String username = (String)message.get((Object)"javax.xml.ws.security.auth.username");
        String password = (String)message.get((Object)"javax.xml.ws.security.auth.password");
        String string = result = value != null ? value : this.getTargetOrEndpoint();
        if (username != null && (slashIdx = result.indexOf("//")) != -1) {
            result = result.substring(0, slashIdx + 2) + username + ":" + password + "@" + result.substring(slashIdx + 2);
        }
        if (null != pathInfo && !result.endsWith(pathInfo)) {
            result = result + pathInfo;
        }
        if (queryString != null) {
            result = result + "?" + queryString;
        }
        return result;
    }

    protected void dispatchMuleMessage(Message m) throws IOException {
        try {
            MuleEvent reqEvent = (MuleEvent)m.getExchange().get((Object)"mule.event");
            MuleMessage req = reqEvent.getMessage();
            req.setOutboundProperty("http.disable.status.code.exception.check", (Object)Boolean.TRUE.toString());
            MuleEvent resEvent = this.processNext(reqEvent, m.getExchange());
            if (resEvent == null || !reqEvent.getEndpoint().getExchangePattern().hasResponse()) {
                m.getExchange().put((Object)"exchange.finished", (Object)Boolean.TRUE);
                return;
            }
            MuleMessage result = resEvent.getMessage();
            InputStream is = this.getResponseBody(m, result);
            if (is != null) {
                MessageImpl inMessage = new MessageImpl();
                String encoding = result.getEncoding();
                inMessage.put((Object)Message.ENCODING, (Object)encoding);
                String contentType = (String)result.getOutboundProperty("Content-Type", (Object)"text/xml");
                if (encoding != null && contentType.indexOf("charset") < 0) {
                    contentType = contentType + "; charset=" + result.getEncoding();
                }
                inMessage.put((Object)"Content-Type", (Object)contentType);
                inMessage.put((Object)"mule.event", (Object)resEvent);
                inMessage.setContent(InputStream.class, (Object)is);
                inMessage.setExchange(m.getExchange());
                this.getMessageObserver().onMessage((Message)inMessage);
            }
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            IOException ex = new IOException("Could not send message to Mule.");
            ex.initCause(e);
            throw ex;
        }
    }

    protected InputStream getResponseBody(Message m, MuleMessage result) throws TransformerException, IOException {
        boolean response;
        boolean bl = response = result != null && !NullPayload.getInstance().equals(result.getPayload()) && !this.isOneway(m.getExchange());
        if (response) {
            InputStream is = (InputStream)result.getPayload(DataTypeFactory.create(InputStream.class));
            PushbackInputStream pb = new PushbackInputStream(is);
            result.setPayload((Object)pb);
            int b = pb.read();
            if (b != -1) {
                pb.unread(b);
                return pb;
            }
        }
        return null;
    }

    protected boolean isOneway(Exchange exchange) {
        return exchange != null && exchange.isOneWay();
    }

    protected String getTargetOrEndpoint() {
        if (this.target != null) {
            return this.target.getAddress().getValue();
        }
        return this.endpoint.getAddress().toString();
    }

    public void onClose(Message m) throws IOException {
    }

    protected MuleEvent processNext(MuleEvent event, Exchange exchange) throws MuleException {
        MuleEvent response;
        CxfOutboundMessageProcessor processor = (CxfOutboundMessageProcessor)((Object)exchange.get((Object)"cxf_outbound_message_processor"));
        if (processor == null) {
            OutboundEndpoint ep = (OutboundEndpoint)event.getEndpoint();
            response = ep.process(event);
        } else {
            response = processor.processNext(event);
            Holder holder = (Holder)exchange.get((Object)"holder");
            holder.value = response;
        }
        return response;
    }

    public void close() {
        if (this.decoupledDestination != null) {
            this.releaseDecoupledDestination();
        }
    }

    protected synchronized void duplicateDecoupledDestination() {
        ++this.decoupledDestinationRefCount;
    }

    protected synchronized void releaseDecoupledDestination() {
        if (--this.decoupledDestinationRefCount == 0) {
            this.decoupledDestination.shutdown();
        }
    }

    public String getDecoupledEndpoint() {
        return this.decoupledEndpoint;
    }

    public void setDecoupledEndpoint(String decoupledEndpoint) {
        this.decoupledEndpoint = decoupledEndpoint;
    }

    protected static EndpointReferenceType getTargetReference(EndpointInfo ei, EndpointReferenceType t) {
        EndpointReferenceType ref = null;
        if (null == t) {
            ref = new EndpointReferenceType();
            AttributedURIType address = new AttributedURIType();
            address.setValue(ei.getAddress());
            ref.setAddress(address);
            if (ei.getService() != null) {
                EndpointReferenceUtils.setServiceAndPortName((EndpointReferenceType)ref, (QName)ei.getService().getName(), (String)ei.getName().getLocalPart());
            }
        } else {
            ref = t;
        }
        return ref;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    protected CxfConfiguration getConnector() {
        return this.configuration;
    }

    protected EndpointInfo getEndpoint() {
        return this.endpoint;
    }

    protected MuleUniversalTransport getTransport() {
        return this.transport;
    }

    protected class InterposedMessageObserver
    implements MessageObserver {
        protected InterposedMessageObserver() {
        }

        public void onMessage(Message inMessage) {
            inMessage.setExchange((Exchange)new ExchangeImpl());
            inMessage.put((Object)"decoupled.channel.message", (Object)Boolean.TRUE);
            inMessage.put((Object)Message.RESPONSE_CODE, (Object)200);
            inMessage.remove((Object)"org.apache.cxf.async.post.response.dispatch");
            MuleUniversalConduit.this.incomingObserver.onMessage(inMessage);
        }
    }
}

