/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.bpm.config;

import org.mule.config.spring.handlers.AbstractMuleNamespaceHandler;
import org.mule.config.spring.parsers.MuleDefinitionParser;
import org.mule.config.spring.parsers.collection.ChildMapEntryDefinitionParser;
import org.mule.config.spring.parsers.generic.MuleOrphanDefinitionParser;
import org.mule.config.spring.parsers.specific.ComponentDefinitionParser;
import org.mule.config.spring.parsers.specific.RouterDefinitionParser;
import org.mule.module.bpm.ProcessComponent;
import org.mule.routing.outbound.EndpointSelector;
import org.mule.transport.bpm.ProcessConnector;
import org.mule.transport.bpm.jbpm.JBpmConnector;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class BpmNamespaceHandler
extends AbstractMuleNamespaceHandler {
    public static final String PROCESS = "process";
    public static final String JBPM_WRAPPER_CLASS = "org.mule.module.jbpm.Jbpm";

    public void init() {
        this.registerStandardTransportEndpoints("bpm", new String[]{PROCESS}).addAlias(PROCESS, "path");
        this.registerConnectorDefinitionParser(ProcessConnector.class);
        this.registerBeanDefinitionParser("outbound-router", (BeanDefinitionParser)new BpmOutboundRouterDefinitionParser());
        this.registerBeanDefinitionParser(PROCESS, (BeanDefinitionParser)new ProcessComponentDefinitionParser());
        this.registerMuleBeanDefinitionParser("process-definition", (MuleDefinitionParser)new ChildMapEntryDefinitionParser("processDefinitions", "name", "resource"));
        try {
            this.registerBeanDefinitionParser("jbpm", (BeanDefinitionParser)new MuleOrphanDefinitionParser(Class.forName(JBPM_WRAPPER_CLASS), true));
        }
        catch (ClassNotFoundException e) {
            this.logger.warn((Object)e.getMessage());
        }
        this.registerBeanDefinitionParser("jbpm-connector", (BeanDefinitionParser)new MuleOrphanDefinitionParser(JBpmConnector.class, true));
    }

    class ProcessComponentDefinitionParser
    extends ComponentDefinitionParser {
        public ProcessComponentDefinitionParser() {
            super(ProcessComponent.class);
            this.addAlias("processName", "name");
            this.addAlias("processDefinition", "resource");
        }
    }

    class BpmOutboundRouterDefinitionParser
    extends RouterDefinitionParser {
        public BpmOutboundRouterDefinitionParser() {
            super(EndpointSelector.class);
        }

        protected void parseChild(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            builder.addPropertyValue("evaluator", (Object)"header");
            builder.addPropertyValue("expression", (Object)"MULE_BPM_ENDPOINT");
            super.parseChild(element, parserContext, builder);
        }
    }
}

