/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.stdio;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.mule.api.MuleContext;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.AbstractConnector;

public abstract class StdioConnector
extends AbstractConnector {
    public static final String STDIO = "stdio";
    public static final String STREAM_SYSTEM_IN = "system.in";
    public static final String STREAM_SYSTEM_OUT = "system.out";
    public static final String STREAM_SYSTEM_ERR = "system.err";
    protected OutputStream outputStream;
    protected InputStream inputStream;

    public StdioConnector(MuleContext context) {
        super(context);
    }

    public MessageReceiver createReceiver(FlowConstruct flowConstruct, InboundEndpoint endpoint) throws Exception {
        return this.serviceDescriptor.createMessageReceiver(this, flowConstruct, endpoint, 1000L);
    }

    public void doStop() {
    }

    protected void doDispose() {
        IOUtils.closeQuietly((InputStream)this.inputStream);
        IOUtils.closeQuietly((OutputStream)this.outputStream);
    }

    public void doStart() {
    }

    public String getProtocol() {
        return STDIO;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void registerListener(InboundEndpoint endpoint, MessageProcessor listener, FlowConstruct flowConstruct) throws Exception {
        if (this.receivers.size() > 0) {
            throw new UnsupportedOperationException("You can only register one listener per system stream connector");
        }
        super.registerListener(endpoint, listener, flowConstruct);
    }
}

