/*
 * $Id: CredentialsNotSetException.java 19661 2010-09-16 12:34:01Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.api.security;

import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.config.i18n.Message;

/**
 * <code>CredentialsNotSetException</code> is thrown when user credentials cannot
 * be obtained from the current message
 */
public class CredentialsNotSetException extends UnauthorisedException
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -6271648179641734580L;

    public CredentialsNotSetException(Message message, MuleEvent event)
    {
        super(message, event);
    }

    public CredentialsNotSetException(Message message, MuleEvent event, Throwable cause)
    {
        super(message, event, cause);
    }

    public CredentialsNotSetException(MuleEvent event, SecurityContext context,
        ImmutableEndpoint endpoint, EndpointSecurityFilter filter)
    {
        super(event, context, endpoint, filter);
    }
}
