/*
 * $Id: DecryptionTransformer.java 19250 2010-08-30 16:53:14Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transformer.encryption;

import org.mule.api.security.CryptoFailureException;

/**
 * <code>EncryptionTransformer</code> will transform an encrypted array of bytes or
 * string into an decrypted array of bytes
 */
public class DecryptionTransformer extends AbstractEncryptionTransformer
{
    @Override
    protected byte[] getTransformedBytes(byte[] buffer) throws CryptoFailureException
    {
        return getStrategy().decrypt(buffer, null);
    }
}
