/*
 * $Id: UnitTestExceptionStrategy.java 19651 2010-09-14 15:22:50Z dirk.olmes $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.soap.axis;

import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.exception.DefaultServiceExceptionStrategy;

import java.util.ArrayList;
import java.util.List;

public class UnitTestExceptionStrategy extends DefaultServiceExceptionStrategy
{
    /**
     * Record all exceptions that this ExceptionStrategy handles so Unit Test
     * can query them and make their assertions.
     */
    private List<Throwable> messagingExceptions = null;
    
    public UnitTestExceptionStrategy(MuleContext context)
    {
        super(context);
        messagingExceptions = new ArrayList<Throwable>();
    }
    
    @Override
    protected void logFatal(MuleMessage message, Throwable t)
    {
        logger.debug("logFatal", t);
    }

    @Override
    protected void logException(Throwable t)
    {
        logger.debug("logException", t);
    }

    @Override
    public void handleMessagingException(MuleMessage message, Throwable t)
    {
        messagingExceptions.add(t);
        super.handleMessagingException(message, t);
    }
    
    public List<Throwable> getMessagingExceptions()
    {
        return messagingExceptions;
    }
}


