/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.inbound;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.ObjectUtils;
import org.mule.util.StringMessageUtils;

public class InboundLoggingMessageProcessor
implements MessageProcessor {
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected InboundEndpoint endpoint;

    public InboundLoggingMessageProcessor(InboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message Received on: " + this.endpoint.getEndpointURI()));
        }
        if (this.logger.isTraceEnabled()) {
            try {
                this.logger.trace((Object)("Message Payload: \n" + StringMessageUtils.truncate(StringMessageUtils.toString(message.getPayload()), 200, false)));
                this.logger.trace((Object)("Message detail: \n" + StringMessageUtils.headersToString(message)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return event;
    }

    public String toString() {
        return ObjectUtils.toString(this);
    }
}

