/*
 * Decompiled with CFR 0.152.
 */
package org.mule.interceptor;

import java.util.List;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorStack
extends AbstractInterceptingMessageProcessor
implements Interceptor,
Initialisable,
Disposable {
    private List<Interceptor> interceptors;
    private MessageProcessor chain;

    public InterceptorStack() {
    }

    public InterceptorStack(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        return this.chain.process(event);
    }

    public List<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    @Override
    public void initialise() throws InitialisationException {
        DefaultMessageProcessorChainBuilder chainBuilder = new DefaultMessageProcessorChainBuilder();
        for (Interceptor interceptor : this.interceptors) {
            if (interceptor instanceof Initialisable) {
                ((Initialisable)((Object)interceptor)).initialise();
            }
            chainBuilder.chain(interceptor);
        }
        if (this.next != null) {
            chainBuilder.chain(this.next);
        }
        try {
            this.chain = chainBuilder.build();
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    @Override
    public void dispose() {
        for (Interceptor interceptor : this.interceptors) {
            if (!(interceptor instanceof Disposable)) continue;
            ((Disposable)((Object)interceptor)).dispose();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.interceptors == null ? 0 : ((Object)this.interceptors).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InterceptorStack other = (InterceptorStack)obj;
        return !(this.interceptors == null ? other.interceptors != null : !((Object)this.interceptors).equals(other.interceptors));
    }
}

