/*
 * Decompiled with CFR 0.152.
 */
package org.mule.lifecycle.processor;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleState;
import org.mule.api.lifecycle.Startable;
import org.mule.config.i18n.CoreMessages;
import org.mule.lifecycle.processor.ProcessIfStartedMessageProcessor;

public class ProcessIfStartedWaitIfPausedMessageProcessor
extends ProcessIfStartedMessageProcessor {
    public ProcessIfStartedWaitIfPausedMessageProcessor(Startable startable, LifecycleState lifecycleState) {
        super(startable, lifecycleState);
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        if (this.isPaused()) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)(this.startable.getClass().getName() + " " + this.getStartableName(this.startable) + " is paused. Blocking call until resumd"));
                }
                while (this.isPaused()) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException e) {
                throw new MessagingException(CoreMessages.interruptedWaitingForPaused(this.getStartableName(this.startable)), event, (Throwable)e);
            }
        }
        return super.processNext(event);
    }

    protected boolean accept(MuleEvent event) {
        return this.lifecycleState.isStarted() || this.isPaused();
    }

    protected boolean isPaused() {
        return this.lifecycleState.isPhaseComplete("pause");
    }
}

