/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transport.PropertyScope;
import org.mule.routing.filters.WildcardFilter;
import org.mule.util.ClassUtils;
import org.mule.util.StringUtils;

public class MessagePropertyFilter
implements Filter {
    protected final transient Log logger = LogFactory.getLog(MessagePropertyFilter.class);
    private boolean caseSensitive = true;
    private boolean not = false;
    private String propertyName;
    private String propertyValue;
    private PropertyScope scope = PropertyScope.OUTBOUND;
    private WildcardFilter wildcardFilter;

    public MessagePropertyFilter() {
    }

    public MessagePropertyFilter(String expression) {
        this.setPattern(expression);
    }

    public boolean accept(MuleMessage message) {
        if (message == null) {
            return false;
        }
        Object value = message.getProperty(this.propertyName, this.scope);
        boolean match = value == null ? this.compare(null, this.propertyValue) : this.compare(value.toString(), this.propertyValue);
        if (!match && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Property: '%s' not found in scope '%s'. Message %n%s", this.propertyName, this.scope, message));
        }
        return match;
    }

    protected boolean compare(String value1, String value2) {
        if (value1 == null && value2 != null && !"null".equals(value2) && this.not) {
            return true;
        }
        if (value1 == null) {
            value1 = "null";
        }
        boolean result = this.wildcardFilter.accept(value1);
        return this.not ? !result : result;
    }

    public String getPattern() {
        return this.propertyName + '=' + this.propertyValue;
    }

    public void setPattern(String expression) {
        int x = expression.indexOf(":");
        int i = expression.indexOf(61);
        if (i == -1) {
            throw new IllegalArgumentException("Pattern is malformed - it should be a key value pair, i.e. property=value: " + expression);
        }
        if (x > -1 && x < i) {
            this.setScope(expression.substring(0, x));
            expression = expression.substring(x + 1);
            i = expression.indexOf(61);
        }
        if (expression.charAt(i - 1) == '!') {
            this.not = true;
            this.propertyName = expression.substring(0, i - 1).trim();
        } else {
            this.propertyName = expression.substring(0, i).trim();
        }
        this.propertyValue = expression.substring(i + 1).trim();
        this.wildcardFilter = new WildcardFilter(this.propertyValue);
        this.wildcardFilter.setCaseSensitive(this.isCaseSensitive());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        if (this.wildcardFilter != null) {
            this.wildcardFilter.setCaseSensitive(caseSensitive);
        }
    }

    public String getScope() {
        return this.scope.getScopeName();
    }

    public void setScope(String scope) {
        if (StringUtils.isBlank((String)scope)) {
            return;
        }
        PropertyScope ps = PropertyScope.get(scope.toLowerCase().trim());
        if (ps == null) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid property scope.", scope));
        }
        this.scope = ps;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MessagePropertyFilter other = (MessagePropertyFilter)obj;
        return ClassUtils.equal(this.propertyName, other.propertyName) && ClassUtils.equal(this.propertyValue, other.propertyValue) && ClassUtils.equal(this.scope, other.scope) && this.caseSensitive == other.caseSensitive;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.getClass(), this.propertyName, this.propertyValue, this.scope, this.caseSensitive});
    }
}

