/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.codec;

import java.io.InputStream;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.Base64;
import org.mule.util.IOUtils;

public class Base64Decoder
extends AbstractTransformer {
    public Base64Decoder() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        try {
            String data;
            if (src instanceof byte[]) {
                data = new String((byte[])src, outputEncoding);
            } else if (src instanceof InputStream) {
                InputStream input = (InputStream)src;
                try {
                    data = IOUtils.toString(input);
                }
                finally {
                    input.close();
                }
            } else {
                data = (String)src;
            }
            byte[] result = Base64.decode(data);
            if (DataTypeFactory.STRING.equals(this.getReturnDataType())) {
                return new String(result, outputEncoding);
            }
            return result;
        }
        catch (Exception ex) {
            throw new TransformerException(CoreMessages.transformFailed("base64", this.getReturnDataType()), this, (Throwable)ex);
        }
    }
}

