/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.compression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.SerializationUtils;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.compression.AbstractCompressionTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.compression.GZipCompression;

public class GZipUncompressTransformer
extends AbstractCompressionTransformer {
    public GZipUncompressTransformer() {
        this.setStrategy(new GZipCompression());
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.BYTE_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        byte[] buffer;
        try {
            byte[] input = null;
            if (src instanceof InputStream) {
                InputStream inputStream = (InputStream)src;
                try {
                    input = IOUtils.toByteArray(inputStream);
                }
                finally {
                    inputStream.close();
                }
            } else {
                input = (byte[])src;
            }
            buffer = this.getStrategy().uncompressByteArray(input);
        }
        catch (IOException e) {
            throw new TransformerException(MessageFactory.createStaticMessage("Failed to uncompress message."), this, (Throwable)e);
        }
        if (!DataTypeFactory.BYTE_ARRAY.equals(this.getReturnDataType())) {
            return SerializationUtils.deserialize((byte[])buffer);
        }
        return buffer;
    }
}

