/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mule.RequestContext;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringMessageUtils;

public class ObjectToString
extends AbstractTransformer
implements DiscoverableTransformer {
    protected static final int DEFAULT_BUFFER_SIZE = 80;
    private int priorityWeighting = 2;

    public ObjectToString() {
        this.registerSourceType(DataTypeFactory.OBJECT);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.registerSourceType(DataTypeFactory.create(OutputHandler.class));
        this.setReturnDataType(DataTypeFactory.TEXT_STRING);
    }

    public Object doTransform(Object src, String outputEncoding) throws TransformerException {
        String output = "";
        output = src instanceof InputStream ? this.createStringFromInputStream((InputStream)src, outputEncoding) : (src instanceof OutputHandler ? this.createStringFromOutputHandler((OutputHandler)src, outputEncoding) : (src instanceof byte[] ? this.createStringFromByteArray((byte[])src, outputEncoding) : StringMessageUtils.toString(src)));
        return output;
    }

    protected String createStringFromInputStream(InputStream input, String outputEncoding) throws TransformerException {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)byteOut);
            String string = byteOut.toString(outputEncoding);
            return string;
        }
        catch (IOException e) {
            throw new TransformerException(CoreMessages.errorReadingStream(), (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                this.logger.warn((Object)"Could not close stream", (Throwable)e);
            }
        }
    }

    protected String createStringFromOutputHandler(OutputHandler handler, String outputEncoding) throws TransformerException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            handler.write(RequestContext.getEvent(), bytes);
            return bytes.toString(outputEncoding);
        }
        catch (IOException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    protected String createStringFromByteArray(byte[] bytes, String outputEncoding) throws TransformerException {
        try {
            return new String(bytes, outputEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

