/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import java.util.List;
import org.cometd.Channel;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.transport.DefaultReplyToHandler;
import org.mule.transport.ajax.BayeuxAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxReplyToHandler
extends DefaultReplyToHandler {
    private Connector connector;

    public AjaxReplyToHandler(List<Transformer> transformers, Connector connector) {
        super(transformers, connector.getMuleContext());
        this.connector = connector;
    }

    public void processReplyTo(MuleEvent event, MuleMessage returnMessage, Object replyTo) throws MuleException {
        Object ret;
        AbstractBayeux bayeux = ((BayeuxAware)this.connector).getBayeux();
        Channel channel = bayeux.getChannel(replyTo.toString(), false);
        if (channel == null) {
            this.logger.warn((Object)("No ajax Channel: " + replyTo + ". Maybe the client unregistered interest."));
            return;
        }
        if (returnMessage.getExceptionPayload() != null) {
            ret = returnMessage.getExceptionPayload().getMessage();
        } else {
            returnMessage.applyTransformers(event, this.getTransformers());
            ret = returnMessage.getPayload();
        }
        for (Client client : channel.getSubscribers()) {
            channel.publish(client, ret, null);
        }
    }
}

