/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.transport.MessageReceiver;
import org.mule.transport.servlet.jetty.ConnectorHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectorHolder<S extends Servlet, R extends MessageReceiver>
implements ConnectorHolder<S, R> {
    protected final transient Log logger = LogFactory.getLog(AbstractConnectorHolder.class);
    protected Connector connector;
    protected S servlet;
    protected boolean started = false;

    public AbstractConnectorHolder(Connector connector, S servlet, R receiver) {
        this.connector = connector;
        this.servlet = servlet;
    }

    @Override
    public S getServlet() {
        return this.servlet;
    }

    @Override
    public Connector getConnector() {
        return this.connector;
    }

    @Override
    public void start() throws MuleException {
        try {
            this.connector.start();
            this.started = true;
        }
        catch (Exception e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
    }

    @Override
    public void stop() throws MuleException {
        try {
            this.connector.stop();
            this.started = false;
        }
        catch (Exception e) {
            this.logger.warn((Object)("Jetty connector did not close cleanly: " + e.getMessage()));
        }
    }
}

