/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms.transformers;

import java.io.IOException;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.api.MuleMessage;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.Connector;
import org.mule.transaction.TransactionCoordination;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsConstants;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.util.ClassUtils;

public abstract class AbstractJmsTransformer
extends AbstractMessageTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public AbstractJmsTransformer() {
        this.declareInputOutputClasses();
    }

    protected abstract void declareInputOutputClasses();

    protected Message transformToMessage(MuleMessage message) throws TransformerException {
        Message message2;
        Session session;
        block17: {
            session = null;
            try {
                Message result;
                Object src = message.getPayload();
                if (src instanceof Message) {
                    result = (Message)src;
                    result.clearProperties();
                } else {
                    session = this.getSession();
                    result = JmsMessageUtils.toMessage(src, session);
                }
                this.setJmsProperties(message, result);
                message2 = result;
                Object var7_7 = null;
                if (session == null || this.endpoint == null) break block17;
            }
            catch (Exception e) {
                try {
                    throw new TransformerException((Transformer)this, (Throwable)e);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (session != null && this.endpoint != null) {
                        Transaction muleTx = TransactionCoordination.getInstance().getTransaction();
                        JmsConnector connector = (JmsConnector)this.endpoint.getConnector();
                        if (muleTx == null) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Closing non-transacted jms session: " + session));
                            }
                            connector.closeQuietly(session);
                        } else if (!muleTx.hasResource((Object)connector.getConnection())) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Closing an orphaned, but transacted jms session: " + session + ", transaction: " + muleTx));
                            }
                            connector.closeQuietly(session);
                        }
                    }
                    session = null;
                    throw throwable;
                }
            }
            Transaction muleTx = TransactionCoordination.getInstance().getTransaction();
            JmsConnector connector = (JmsConnector)this.endpoint.getConnector();
            if (muleTx == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing non-transacted jms session: " + session));
                }
                connector.closeQuietly(session);
            } else if (!muleTx.hasResource((Object)connector.getConnection())) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Closing an orphaned, but transacted jms session: " + session + ", transaction: " + muleTx));
                }
                connector.closeQuietly(session);
            }
        }
        session = null;
        return message2;
    }

    protected Object transformFromMessage(Message source, String outputEncoding) throws IOException, JMSException {
        Connector connector;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message type received is: " + ClassUtils.getSimpleName(source.getClass())));
        }
        String jmsSpec = "1.0.2b";
        if (this.endpoint != null && (connector = this.endpoint.getConnector()) instanceof JmsConnector) {
            jmsSpec = ((JmsConnector)connector).getSpecification();
        }
        return JmsMessageUtils.toObject(source, jmsSpec, outputEncoding);
    }

    public void setJmsProperties(MuleMessage message, Message msg) throws JMSException {
        for (String key : message.getOutboundPropertyNames()) {
            if (JmsConstants.JMS_PROPERTY_NAMES.contains(key)) continue;
            Object value = message.getOutboundProperty(key);
            if ("MULE_CORRELATION_ID".equals(key)) {
                msg.setJMSCorrelationID(message.getCorrelationId());
            }
            if ("MULE_REPLYTO".equals(key) && value instanceof Destination) continue;
            key = JmsMessageUtils.encodeHeader(key);
            try {
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Unable to set property '" + key + "' of type " + ClassUtils.getSimpleName(value.getClass()) + "': " + e.getMessage()));
            }
        }
    }

    protected Session getSession() throws JMSException {
        if (this.endpoint != null) {
            return ((JmsConnector)this.endpoint.getConnector()).getSession(this.endpoint);
        }
        throw new IllegalStateException("This transformer needs a valid endpoint");
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }
}

