/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.util.concurrent.Latch;

public class DynamicOutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    protected FakeMessageDispatcher dispacher;
    protected MuleEvent testOutboundEvent;

    public void testDefaultFlowRequestResponse() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        this.setUpFakeDispatcher(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        DynamicOutboundEndpointTestCase.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    public void testDefaultFlowOneWay() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        Thread.sleep(1000L);
        this.setUpFakeDispatcher(endpoint);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.dispacher.latch.await(5000L, TimeUnit.MILLISECONDS);
        this.assertMessageSentSame(false);
        DynamicOutboundEndpointTestCase.assertNull((Object)result);
    }

    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (EndpointSecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        this.setUpFakeDispatcher(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        DynamicOutboundEndpointTestCase.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (EndpointSecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        this.setUpFakeDispatcher(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageNotSent();
        DynamicOutboundEndpointTestCase.assertNotNull((Object)result);
        DynamicOutboundEndpointTestCase.assertEquals((String)"unauthorized!!", (String)result.getMessage().getPayloadAsString());
        DynamicOutboundEndpointTestCase.assertNotNull((Object)result.getMessage().getExceptionPayload());
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(result.getMessage().getExceptionPayload().getException() instanceof TestSecurityFilter.StaticMessageUnauthorisedException));
        DynamicOutboundEndpointTestCase.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        DynamicOutboundEndpointTestCase.assertEquals((int)401, (int)securityNotificationListener.securityNotification.getAction());
        DynamicOutboundEndpointTestCase.assertEquals((String)securityNotificationListener.securityNotification.getResourceIdentifier(), (String)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    public void testSendNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(outboundEvent);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        DynamicOutboundEndpointTestCase.assertEquals((int)803, (int)listener.messageNotification.getAction());
        DynamicOutboundEndpointTestCase.assertEquals((String)endpoint.getEndpointURI().getUri().toString(), (String)listener.messageNotification.getEndpoint());
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        DynamicOutboundEndpointTestCase.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    public void testDispatchNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(outboundEvent);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        DynamicOutboundEndpointTestCase.assertEquals((int)802, (int)listener.messageNotification.getAction());
        DynamicOutboundEndpointTestCase.assertEquals((String)endpoint.getEndpointURI().getUri().toString(), (String)listener.messageNotification.getEndpoint());
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        DynamicOutboundEndpointTestCase.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)listener.messageNotification.getSource().getPayload());
    }

    public void testTransformers() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)new OutboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        this.setUpFakeDispatcher(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSent(true);
        DynamicOutboundEndpointTestCase.assertEquals((String)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (String)this.dispacher.sensedSendEvent.getMessageAsString());
        DynamicOutboundEndpointTestCase.assertNotNull((Object)result);
        DynamicOutboundEndpointTestCase.assertEquals((String)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (String)result.getMessageAsString());
    }

    public void testConnectorNotStarted() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(this.testOutboundEvent);
        endpoint.getConnector().stop();
        try {
            endpoint.process(this.testOutboundEvent);
            DynamicOutboundEndpointTestCase.fail((String)"exception expected");
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        DynamicOutboundEndpointTestCase.assertTrue((boolean)(endpoint instanceof DynamicOutboundEndpoint));
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        endpoint.process(this.testOutboundEvent);
        this.setUpFakeDispatcher(endpoint);
        endpoint.process(this.testOutboundEvent);
        DynamicOutboundEndpointTestCase.assertEquals((int)testTimeout, (int)this.dispacher.sensedSendEvent.getTimeout());
    }

    public void testTransaction() {
    }

    public void testExceptionHandling() {
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event;
        if (sync) {
            DynamicOutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedDispatchEvent);
            DynamicOutboundEndpointTestCase.assertNotNull((Object)this.dispacher.sensedSendEvent);
            event = this.dispacher.sensedSendEvent;
        } else {
            DynamicOutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedSendEvent);
            DynamicOutboundEndpointTestCase.assertNotNull((Object)this.dispacher.sensedDispatchEvent);
            event = this.dispacher.sensedDispatchEvent;
        }
        DynamicOutboundEndpointTestCase.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        MuleEvent event = this.assertMessageSent(sync);
        if (sync) {
            DynamicOutboundEndpointTestCase.assertEquals((Object)this.testOutboundEvent, (Object)event);
        }
        DynamicOutboundEndpointTestCase.assertEquals((String)"Test Message", (String)event.getMessageAsString());
        DynamicOutboundEndpointTestCase.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        DynamicOutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedSendEvent);
        DynamicOutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedDispatchEvent);
    }

    protected void assertMessageEqualEncodingPropertyAdded(MuleMessage expect, MuleMessage actual) {
        DynamicOutboundEndpointTestCase.assertEquals((Object)expect.getPayload(), (Object)actual.getPayload());
        DynamicOutboundEndpointTestCase.assertEquals((String)expect.getEncoding(), (String)actual.getEncoding());
        DynamicOutboundEndpointTestCase.assertEquals((String)expect.getUniqueId(), (String)actual.getUniqueId());
        DynamicOutboundEndpointTestCase.assertEquals((Object)expect.getExceptionPayload(), (Object)actual.getExceptionPayload());
        DynamicOutboundEndpointTestCase.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)actual.getOutboundProperty("MULE_ENCODING"));
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createTestOutboundEndpoint("test://localhost:#[header:port]", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    protected void setUpFakeDispatcher(OutboundEndpoint endpoint) {
        this.dispacher = new FakeMessageDispatcher(endpoint);
        Connector connector = endpoint.getConnector();
        connector.setDispatcherFactory((MessageDispatcherFactory)new TestMessageDispatcherFactory(){

            public MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
                return DynamicOutboundEndpointTestCase.this.dispacher;
            }
        });
    }

    static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        Latch latch = new Latch();
        MuleEvent sensedSendEvent;
        MuleEvent sensedDispatchEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.latch.countDown();
            return responseMessage;
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.latch.countDown();
        }
    }
}

