/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import org.mule.api.MuleException;
import org.mule.api.service.Service;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractServiceTestCase
extends AbstractMuleTestCase {
    protected abstract Service getService();

    public void testStart() throws MuleException {
        try {
            this.getService().start();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot start an uninitialised service");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.getService().initialise();
        this.getService().start();
        try {
            this.getService().initialise();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot initialise an already initialised service");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.getService().dispose();
    }

    public void testPause() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().resume();
            AbstractServiceTestCase.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().start();
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().pause();
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isPaused());
        try {
            this.getService().pause();
            AbstractServiceTestCase.fail((String)"cannot pause a service that is already paused");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isPaused());
        this.getService().dispose();
    }

    public void testResume() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().resume();
            AbstractServiceTestCase.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().start();
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().resume();
            AbstractServiceTestCase.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().pause();
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isPaused());
        this.getService().resume();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isStarted());
        try {
            this.getService().resume();
            AbstractServiceTestCase.fail((String)"cannot resume a service that is not paused");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().dispose();
    }

    public void testStop() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        try {
            this.getService().stop();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot stop an uninitialised service");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.getService().resume();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot resume an uninitialised service");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        this.getService().initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        this.getService().stop();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        this.getService().start();
        AbstractServiceTestCase.assertTrue((boolean)this.getService().isStarted());
        this.getService().stop();
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        try {
            this.getService().stop();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot stop a service that is not started");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        this.getService().dispose();
    }

    public void testDispose() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.getService().isPaused());
        this.getService().dispose();
        try {
            this.getService().dispose();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot dispose a service that is already disposed");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            this.getService().initialise();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot invoke initialise (or any lifecycle) on an object once it is disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

