/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.security;

import org.mule.security.SecretKeyEncryptionStrategy;
import org.mule.security.SecretKeyFactory;
import org.mule.tck.AbstractMuleTestCase;

public class SecretKeyEncryptionStrategyTestCase
extends AbstractMuleTestCase {
    public void testRoundTripEncryptionBlowfish() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("Blowfish");
        ske.setKey("shhhhh");
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        SecretKeyEncryptionStrategyTestCase.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        SecretKeyEncryptionStrategyTestCase.assertEquals((String)"hello", (String)s);
    }

    public void testRoundTripEncryptionBlowfishWithKeyFactory() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("Blowfish");
        ske.setKeyFactory(new SecretKeyFactory(){

            public byte[] getKey() {
                return "shhhh".getBytes();
            }
        });
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        SecretKeyEncryptionStrategyTestCase.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        SecretKeyEncryptionStrategyTestCase.assertEquals((String)"hello", (String)s);
    }

    public void testRoundTripEncryptionTripleDES() throws Exception {
        SecretKeyEncryptionStrategy ske = new SecretKeyEncryptionStrategy();
        ske.setAlgorithm("TripleDES");
        ske.setKey("shhhhh");
        ske.initialise();
        byte[] b = ske.encrypt("hello".getBytes(), null);
        SecretKeyEncryptionStrategyTestCase.assertNotSame((Object)new String(b), (Object)"hello");
        String s = new String(ske.decrypt(b, null), "UTF-8");
        SecretKeyEncryptionStrategyTestCase.assertEquals((String)"hello", (String)s);
    }
}

