/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.queue;

import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueConfiguration;
import org.mule.util.queue.QueueSession;
import org.mule.util.queue.TransactionalQueueManager;

public abstract class AbstractTransactionQueueManagerTestCase
extends AbstractMuleTestCase {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    protected abstract TransactionalQueueManager createQueueManager() throws Exception;

    protected abstract boolean isPersistent();

    public void testPutTake() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        q.put((Object)"String1");
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
        Object o = q.take();
        AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        this.purgeQueue(q);
        mgr.stop(0);
    }

    public void testTakePut() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread(){

            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (int)0, (int)q.size());
                    q.put((Object)"String1");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        Object o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        AbstractTransactionQueueManagerTestCase.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    public void testTakePutRollbackPut() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        final Latch latch = new Latch();
        Thread t = new Thread(){

            public void run() {
                try {
                    latch.countDown();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Assert.assertEquals((String)"Queue size", (int)0, (int)q.size());
                    s.begin();
                    q.put((Object)"String1");
                    s.rollback();
                    s.begin();
                    q.put((Object)"String2");
                    s.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        latch.await();
        long t0 = System.currentTimeMillis();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        Object o = q.take();
        long t1 = System.currentTimeMillis();
        t.join();
        AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String2", (Object)o);
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        AbstractTransactionQueueManagerTestCase.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    public void testTakePutOverCapacity() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        mgr.setDefaultQueueConfiguration(new QueueConfiguration(2));
        final Latch latch = new Latch();
        Thread t = new Thread(){

            public void run() {
                try {
                    latch.await();
                    Thread.sleep(200L);
                    QueueSession s = mgr.getQueueSession();
                    Queue q = s.getQueue("queue1");
                    Object o = q.take();
                    Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("queue1");
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
        q.put((Object)"String1");
        q.put((Object)"String2");
        latch.countDown();
        long t0 = System.currentTimeMillis();
        q.put((Object)"String3");
        long t1 = System.currentTimeMillis();
        t.join();
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)2, (int)q.size());
        AbstractTransactionQueueManagerTestCase.assertTrue((t1 - t0 > 100L ? 1 : 0) != 0);
        this.purgeQueue(q);
        mgr.stop(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPutWithPersistence() throws Exception {
        if (this.isPersistent()) {
            Queue q;
            QueueSession s;
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                q.put((Object)"String1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            }
            finally {
                mgr.stop(0);
            }
            mgr = this.createQueueManager();
            try {
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        }
        this.logger.info((Object)"Ignoring test because queue manager is not persistent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactedPutCommitWithPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                mgr.start();
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                s.begin();
                q.put((Object)"String1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                s.commit();
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                mgr.stop(0);
                mgr = this.createQueueManager();
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        } else {
            this.logger.info((Object)"Ignoring test because queue manager is not persistent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactedPutRollbackWithPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr = this.createQueueManager();
            try {
                mgr.start();
                QueueSession s = mgr.getQueueSession();
                Queue q = s.getQueue("queue1");
                s.begin();
                q.put((Object)"String1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
                s.rollback();
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
                mgr.stop(0);
                mgr = this.createQueueManager();
                mgr.start();
                s = mgr.getQueueSession();
                q = s.getQueue("queue1");
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
                this.purgeQueue(q);
            }
            finally {
                mgr.stop(0);
            }
        } else {
            this.logger.info((Object)"Ignoring test because queue manager is not persistent");
        }
    }

    public void testPutTake_RespectsOrderOnPersistence() throws Exception {
        if (this.isPersistent()) {
            TransactionalQueueManager mgr1 = this.createQueueManager();
            mgr1.start();
            QueueSession s1 = mgr1.getQueueSession();
            Queue q1 = s1.getQueue("queue1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1.size());
            int numberOfElements = 10;
            for (int i = 1; i <= 10; ++i) {
                q1.put((Object)("String" + i));
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)i, (int)q1.size());
            }
            mgr1.stop(0);
            TransactionalQueueManager mgr2 = this.createQueueManager();
            mgr2.start();
            QueueSession s2 = mgr2.getQueueSession();
            Queue q2 = s2.getQueue("queue1");
            for (int i = 1; i <= 10; ++i) {
                Object o = q2.take();
                AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
                AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)("String" + i), (Object)o);
            }
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2.size());
            this.purgeQueue(q2);
            mgr2.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTransactionsOnMultipleQueues() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s1 = mgr.getQueueSession();
            QueueSession s2 = mgr.getQueueSession();
            Queue q1s1 = s1.getQueue("queue1");
            Queue q1s2 = s2.getQueue("queue1");
            Queue q2s1 = s1.getQueue("queue2");
            Queue q2s2 = s2.getQueue("queue2");
            q1s1.put((Object)"String1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q1s2.size());
            s1.begin();
            Object o = q1s1.take();
            AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
            AbstractTransactionQueueManagerTestCase.assertEquals((Object)"String1", (Object)o);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s2.size());
            q2s1.put((Object)"String2");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q2s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2s2.size());
            s1.commit();
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s2.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q2s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q2s2.size());
            s1.begin();
            o = q2s1.take();
            AbstractTransactionQueueManagerTestCase.assertNotNull((Object)o);
            AbstractTransactionQueueManagerTestCase.assertEquals((Object)"String2", (Object)o);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s2.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2s2.size());
            q1s1.put((Object)"String1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s2.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q2s2.size());
            s1.rollback();
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q1s2.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q2s1.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q2s2.size());
            this.purgeQueue(q1s1);
            this.purgeQueue(q1s2);
            this.purgeQueue(q2s1);
            this.purgeQueue(q2s2);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPoll() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            Object o = q.poll(0L);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertNull((Object)o);
            o = q.poll(1000L);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertNull((Object)o);
            q.put((Object)"String1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            o = q.poll(0L);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        QueueSession s = mgr.getQueueSession();
                        Queue q = s.getQueue("queue1");
                        q.put((Object)"String1");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            o = q.poll(1000L);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)q.size(), (int)0);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPeek() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            Object o = q.peek();
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertNull((Object)o);
            q.put((Object)"String1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            o = q.peek();
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            o = q.poll(1000L);
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue content", (Object)"String1", (Object)o);
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOffer() throws Exception {
        final TransactionalQueueManager mgr = this.createQueueManager();
        mgr.setDefaultQueueConfiguration(new QueueConfiguration(1));
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)0, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertTrue((boolean)q.offer((Object)"String1", 0L));
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            AbstractTransactionQueueManagerTestCase.assertFalse((boolean)q.offer((Object)"String2", 1000L));
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                        QueueSession s = mgr.getQueueSession();
                        Queue q = s.getQueue("queue1");
                        Assert.assertEquals((String)"Queue content", (Object)"String1", (Object)q.take());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            AbstractTransactionQueueManagerTestCase.assertTrue((boolean)q.offer((Object)"String2", 1000L));
            AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue size", (int)1, (int)q.size());
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBench() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        try {
            mgr.start();
            QueueSession s = mgr.getQueueSession();
            Queue q = s.getQueue("queue1");
            Random rnd = new Random();
            long t0 = System.currentTimeMillis();
            for (int i = 0; i < 1; ++i) {
                for (int j = 0; j < 500; ++j) {
                    byte[] o = new byte[2048];
                    rnd.nextBytes(o);
                    q.put((Object)o);
                }
                while (q.size() > 0) {
                    q.take();
                }
            }
            long t1 = System.currentTimeMillis();
            this.logger.info((Object)("Time: " + (t1 - t0) + " ms"));
            this.purgeQueue(q);
        }
        finally {
            mgr.stop(0);
        }
    }

    protected void purgeQueue(Queue queue) throws InterruptedException {
        while (queue.size() > 0) {
            queue.poll(1000L);
        }
        AbstractTransactionQueueManagerTestCase.assertEquals((String)"Queue must be fully consumed after successful test run. Queue size:", (int)0, (int)queue.size());
    }

    public void testRecoverWarmRestart() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        int toPopulate = 500;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Object)o);
        }
        AbstractTransactionQueueManagerTestCase.assertEquals((int)q.size(), (int)toPopulate);
        mgr.stop();
        mgr.start();
        AbstractTransactionQueueManagerTestCase.assertEquals((int)toPopulate, (int)q.size());
    }

    public void testRecoverColdRestart() throws Exception {
        TransactionalQueueManager mgr = this.createQueueManager();
        mgr.start();
        QueueSession s = mgr.getQueueSession();
        Queue q = s.getQueue("warmRecoverQueue");
        int toPopulate = 500;
        Random rnd = new Random();
        for (int j = 0; j < toPopulate; ++j) {
            byte[] o = new byte[2048];
            rnd.nextBytes(o);
            q.put((Object)o);
        }
        AbstractTransactionQueueManagerTestCase.assertEquals((int)toPopulate, (int)q.size());
        mgr.stop();
        mgr = this.createQueueManager();
        mgr.start();
        s = mgr.getQueueSession();
        q = s.getQueue("warmRecoverQueue");
        if (this.isPersistent()) {
            AbstractTransactionQueueManagerTestCase.assertEquals((int)toPopulate, (int)q.size());
        } else {
            AbstractTransactionQueueManagerTestCase.assertEquals((int)0, (int)q.size());
        }
    }
}

