/*
 * $Id: CopyAttachmentInInterceptor.java 19191 2010-08-25 21:05:23Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.module.cxf.support;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.cxf.CxfConstants;
import org.mule.transport.http.HttpConstants;

import java.util.Collection;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.Phase;

import static org.mule.api.config.MuleProperties.MULE_EVENT_PROPERTY;

public class CopyAttachmentInInterceptor extends AbstractPhaseInterceptor
{
    public CopyAttachmentInInterceptor()
    {
        super(Phase.PRE_INVOKE);
    }

    public void handleMessage(Message message) throws Fault
    {
        MuleEvent event = (MuleEvent) message.get(MULE_EVENT_PROPERTY);
        MuleMessage muleMsg;
        if (event == null) 
        {
            event = (MuleEvent) message.get(CxfConstants.MULE_EVENT);
        } 
        
        muleMsg = event.getMessage();
        Collection<Attachment> atts = message.getAttachments();
        if (atts != null)
        {
            muleMsg.setOutboundProperty(CxfConstants.ATTACHMENTS, atts);
            muleMsg.setOutboundProperty(HttpConstants.HEADER_CONTENT_TYPE, muleMsg.getInboundProperty(HttpConstants.HEADER_CONTENT_TYPE));
        }
    }

}


