/*
 * $Id: SecurityNamespaceHandlerTestCase.java 19191 2010-08-25 21:05:23Z tcarlson $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.test.config;

import org.mule.api.EncryptionStrategy;
import org.mule.api.security.SecurityManager;
import org.mule.security.PasswordBasedEncryptionStrategy;
import org.mule.security.SecretKeyEncryptionStrategy;
import org.mule.tck.FunctionalTestCase;
import org.mule.tck.security.MockEncryptionStrategy;
import org.mule.tck.security.TestSingleUserSecurityProvider;

import java.util.Iterator;

public class SecurityNamespaceHandlerTestCase extends FunctionalTestCase
{

    protected String getConfigResources()
    {
        return "security-namespace-config.xml";
    }

    public void testSecurity()
    {
        SecurityManager securityManager = muleContext.getSecurityManager();
        assertNotNull(securityManager.getProvider("dummySecurityProvider"));
        assertTrue(securityManager.getProvider("dummySecurityProvider") instanceof TestSingleUserSecurityProvider);
        verifyEncryptionStrategy(securityManager, "dummyEncryptionStrategy", MockEncryptionStrategy.class);
        verifyEncryptionStrategy(securityManager, "passwordEncryptionStrategy", PasswordBasedEncryptionStrategy.class);
        verifyEncryptionStrategy(securityManager, "secretKeyEncryptionStrategy", SecretKeyEncryptionStrategy.class);
    }
    
    private void verifyEncryptionStrategy(SecurityManager securityManager, String name, Class clazz)
    {
        Iterator strategies = securityManager.getEncryptionStrategies().iterator();
        logger.debug("Listing strategies");
        while (strategies.hasNext())
        {
            EncryptionStrategy strategy = (EncryptionStrategy) strategies.next();
            logger.debug(strategy.getName() + " / " + strategy.toString() + " / " + strategy.getClass());
        }
        assertNotNull(name, securityManager.getEncryptionStrategy(name));
        assertTrue(securityManager.getEncryptionStrategy(name).getClass().equals(clazz));
    }

}
