/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tsp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TSPValidationException;
import org.bouncycastle.tsp.TimeStampToken;
import org.bouncycastle.tsp.TimeStampTokenInfo;
import org.bouncycastle.util.Arrays;

public class TSPUtil {
    private static final Map digestLengths = new HashMap();
    private static final Map digestNames = new HashMap();

    public static Collection getSignatureTimestamps(SignerInformation signerInformation, Provider provider) throws TSPValidationException {
        ArrayList<TimeStampToken> arrayList = new ArrayList<TimeStampToken>();
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        if (attributeTable != null) {
            ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
            for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(i);
                ASN1Set aSN1Set = attribute.getAttrValues();
                for (int j = 0; j < aSN1Set.size(); ++j) {
                    try {
                        ContentInfo contentInfo = ContentInfo.getInstance((Object)aSN1Set.getObjectAt(j).getDERObject());
                        TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
                        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
                        MessageDigest messageDigest = TSPUtil.createDigestInstance(timeStampTokenInfo.getMessageImprintAlgOID(), provider);
                        byte[] byArray = messageDigest.digest(signerInformation.getSignature());
                        if (!Arrays.constantTimeAreEqual((byte[])byArray, (byte[])timeStampTokenInfo.getMessageImprintDigest())) {
                            throw new TSPValidationException("Incorrect digest in message imprint");
                        }
                        arrayList.add(timeStampToken);
                        continue;
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new TSPValidationException("Unknown hash algorithm specified in timestamp");
                    }
                    catch (Exception exception) {
                        throw new TSPValidationException("Timestamp could not be parsed");
                    }
                }
            }
        }
        return arrayList;
    }

    public static void validateCertificate(X509Certificate x509Certificate) throws TSPValidationException {
        if (x509Certificate.getVersion() != 3) {
            throw new IllegalArgumentException("Certificate must have an ExtendedKeyUsage extension.");
        }
        byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.ExtendedKeyUsage.getId());
        if (byArray == null) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension.");
        }
        if (!x509Certificate.getCriticalExtensionOIDs().contains(X509Extensions.ExtendedKeyUsage.getId())) {
            throw new TSPValidationException("Certificate must have an ExtendedKeyUsage extension marked as critical.");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        try {
            aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((ASN1OctetString)aSN1InputStream.readObject()).getOctets()));
            ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)aSN1InputStream.readObject());
            if (!extendedKeyUsage.hasKeyPurposeId(KeyPurposeId.id_kp_timeStamping) || extendedKeyUsage.size() != 1) {
                throw new TSPValidationException("ExtendedKeyUsage not solely time stamping.");
            }
        }
        catch (IOException iOException) {
            throw new TSPValidationException("cannot process ExtendedKeyUsage extension");
        }
    }

    static String getDigestAlgName(String string) {
        String string2 = (String)digestNames.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    static int getDigestLength(String string, String string2) throws NoSuchProviderException, TSPException {
        String string3 = TSPUtil.getDigestAlgName(string);
        try {
            Integer n = (Integer)digestLengths.get(string);
            if (n != null) {
                return n;
            }
            return MessageDigest.getInstance(string3, string2).getDigestLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                return MessageDigest.getInstance(string3).getDigestLength();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new TSPException("digest algorithm cannot be found.", noSuchAlgorithmException2);
            }
        }
    }

    static MessageDigest createDigestInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        String string2 = TSPUtil.getDigestAlgName(string);
        if (provider != null) {
            try {
                return MessageDigest.getInstance(string2, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(string2);
    }

    static {
        digestLengths.put(PKCSObjectIdentifiers.md5.getId(), new Integer(16));
        digestLengths.put(OIWObjectIdentifiers.idSHA1.getId(), new Integer(20));
        digestLengths.put(NISTObjectIdentifiers.id_sha224.getId(), new Integer(28));
        digestLengths.put(NISTObjectIdentifiers.id_sha256.getId(), new Integer(32));
        digestLengths.put(NISTObjectIdentifiers.id_sha384.getId(), new Integer(48));
        digestLengths.put(NISTObjectIdentifiers.id_sha512.getId(), new Integer(64));
        digestNames.put(PKCSObjectIdentifiers.md5.getId(), "MD5");
        digestNames.put(OIWObjectIdentifiers.idSHA1.getId(), "SHA1");
        digestNames.put(NISTObjectIdentifiers.id_sha224.getId(), "SHA224");
        digestNames.put(NISTObjectIdentifiers.id_sha256.getId(), "SHA256");
        digestNames.put(NISTObjectIdentifiers.id_sha384.getId(), "SHA384");
        digestNames.put(NISTObjectIdentifiers.id_sha512.getId(), "SHA512");
        digestNames.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), "SHA1");
        digestNames.put(PKCSObjectIdentifiers.sha224WithRSAEncryption.getId(), "SHA224");
        digestNames.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), "SHA256");
        digestNames.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), "SHA384");
        digestNames.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), "SHA512");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd128.getId(), "RIPEMD128");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd160.getId(), "RIPEMD160");
        digestNames.put(TeleTrusTObjectIdentifiers.ripemd256.getId(), "RIPEMD256");
        digestNames.put(CryptoProObjectIdentifiers.gostR3411.getId(), "GOST3411");
    }
}

