/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.mule.api.MuleEventContext;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.ExplicitMethodEntryPointResolver;
import org.mule.mule.model.MultiplePayloadsTestObject;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Fruit;

public class ExplicitMethodEntryPointResolverTestCase
extends AbstractMuleTestCase {
    public void testMethodSetPass() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        ExplicitMethodEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testMethodSetMatchFirst() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("someBusinessMethod");
        resolver.addMethod("someSetter");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        ExplicitMethodEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public void testMethodNotFound() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("noMethod");
        resolver.addMethod("noMethod2");
        InvocationResult result = resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
        ExplicitMethodEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.FAILED);
    }

    public void testNoMethodSet() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        try {
            resolver.invoke((Object)new MultiplePayloadsTestObject(), ExplicitMethodEntryPointResolverTestCase.getTestEventContext("blah"));
            ExplicitMethodEntryPointResolverTestCase.fail((String)"method property is not set, this should cause an error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMethodPropertyParameterAssignableFromPayload() throws Exception {
        ExplicitMethodEntryPointResolver resolver = new ExplicitMethodEntryPointResolver();
        resolver.addMethod("wash");
        MuleEventContext ctx = ExplicitMethodEntryPointResolverTestCase.getTestEventContext(new Apple());
        InvocationResult result = resolver.invoke((Object)new TestFruitCleaner(), ctx);
        ExplicitMethodEntryPointResolverTestCase.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
    }

    public static class TestFruitCleaner {
        public void wash(Fruit fruit) {
        }

        public void polish(Fruit fruit) {
        }
    }
}

