/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.InterceptingMessageProcessor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.ObjectUtils;

public class DefaultMessageProcessorChainTestCase
extends AbstractMuleTestCase {
    @Test
    public void testMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new AppendingMP("2"), new AppendingMP("3")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0123", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    public void testMPChainWithBuilder() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1")});
        builder.chain(new MessageProcessorBuilder[]{new MessageProcessorBuilder(){

            public MessageProcessor build() {
                return new AppendingMP("2");
            }
        }});
        builder.chain(new MessageProcessor[]{new AppendingMP("3")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0123", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2"), new AppendingInterceptingMP("3")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0before1before2before3after3after2after1", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingMP("2"), new AppendingMP("3"), new AppendingInterceptingMP("4"), new AppendingMP("5")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0before123before45after4after1", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testNestedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingMP("a"), new AppendingMP("b")}).build(), new AppendingMP("2")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"01ab2", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testNestedInterceptingMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("2")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0before1beforeabeforebafterbafterabefore2after2after1", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testNestedMixedMPChain() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a"), new AppendingMP("b")}).build(), new AppendingInterceptingMP("2")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"01beforeabafterabefore2after2", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new AppendingInterceptingMP("2", true), new AppendingInterceptingMP("3")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0before1after1", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testNestedInterceptingMPChainStopFlow() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new AppendingInterceptingMP("1"), new DefaultMessageProcessorChainBuilder().chain(new MessageProcessor[]{new AppendingInterceptingMP("a", true), new AppendingInterceptingMP("b")}).build(), new AppendingInterceptingMP("3")});
        DefaultMessageProcessorChainTestCase.assertEquals((String)"0before1before3after3after1", (String)builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent("0")).getMessageAsString());
    }

    @Test
    public void testMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, mp2}).build();
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
    }

    @Test
    public void testNestedMPChainLifecycle() throws MuleException, Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        DefaultMessageProcessorChainBuilder nestedBuilder = new DefaultMessageProcessorChainBuilder();
        AppendingInterceptingMP mp1 = new AppendingInterceptingMP("1");
        AppendingInterceptingMP mp2 = new AppendingInterceptingMP("2");
        AppendingInterceptingMP mpa = new AppendingInterceptingMP("a");
        AppendingInterceptingMP mpb = new AppendingInterceptingMP("b");
        MessageProcessorChain chain = builder.chain(new MessageProcessor[]{mp1, nestedBuilder.chain(new MessageProcessor[]{mpa, mpb}).build(), mp2}).build();
        ((Lifecycle)chain).initialise();
        ((Lifecycle)chain).start();
        ((Lifecycle)chain).stop();
        ((Lifecycle)chain).dispose();
        this.assertLifecycle(mp1);
        this.assertLifecycle(mp2);
        this.assertLifecycle(mpa);
        this.assertLifecycle(mpb);
    }

    public void testNoneIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent(""));
        DefaultMessageProcessorChainTestCase.assertEquals((String)"MessageProcessorMessageProcessorMessageProcessor", (String)restul.getMessageAsString());
    }

    public void testAllIntercepting() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestIntercepting(), new TestIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent(""));
        DefaultMessageProcessorChainTestCase.assertEquals((String)"InterceptingMessageProcessorInterceptingMessageProcessorInterceptingMessageProcessor", (String)restul.getMessageAsString());
    }

    public void testMix() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent(""));
        DefaultMessageProcessorChainTestCase.assertEquals((String)"InterceptingMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessor", (String)restul.getMessageAsString());
    }

    public void testMix2() throws Exception {
        DefaultMessageProcessorChainBuilder builder = new DefaultMessageProcessorChainBuilder();
        builder.chain(new MessageProcessor[]{new TestNonIntercepting(), new TestIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestNonIntercepting(), new TestIntercepting()});
        MuleEvent restul = builder.build().process(DefaultMessageProcessorChainTestCase.getTestEvent(""));
        DefaultMessageProcessorChainTestCase.assertEquals((String)"MessageProcessorInterceptingMessageProcessorMessageProcessorMessageProcessorMessageProcessorInterceptingMessageProcessor", (String)restul.getMessageAsString());
    }

    private void assertLifecycle(AppendingMP mp) {
        DefaultMessageProcessorChainTestCase.assertTrue((boolean)mp.initialised);
        DefaultMessageProcessorChainTestCase.assertTrue((boolean)mp.started);
        DefaultMessageProcessorChainTestCase.assertTrue((boolean)mp.stopped);
        DefaultMessageProcessorChainTestCase.assertTrue((boolean)mp.disposed);
    }

    private static class AppendingInterceptingMP
    extends AppendingMP
    implements InterceptingMessageProcessor {
        private boolean stopProcessing;
        private MessageProcessor next;

        public AppendingInterceptingMP(String append) {
            this(append, false);
        }

        public AppendingInterceptingMP(String append, boolean stopProcessing) {
            super(append);
            this.stopProcessing = stopProcessing;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.stopProcessing) {
                return event;
            }
            DefaultMuleEvent intermediateEvent = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessageAsString() + "before" + this.appendString), muleContext), event);
            if (this.next != null) {
                intermediateEvent = this.next.process((MuleEvent)intermediateEvent);
            }
            return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(intermediateEvent.getMessageAsString() + "after" + this.appendString), muleContext), (MuleEvent)intermediateEvent);
        }

        public void setListener(MessageProcessor mp) {
            this.next = mp;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }

    private static class AppendingMP
    implements MessageProcessor,
    Lifecycle {
        String appendString;
        boolean initialised;
        boolean started;
        boolean stopped;
        boolean disposed;

        public AppendingMP(String append) {
            this.appendString = append;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)(event.getMessageAsString() + this.appendString), muleContext), event);
        }

        public void initialise() throws InitialisationException {
            this.initialised = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public void dispose() {
            this.disposed = true;
        }

        public String toString() {
            return ObjectUtils.toString((Object)this);
        }
    }

    static class TestIntercepting
    extends AbstractInterceptingMessageProcessor {
        TestIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return this.processNext(new StringAppendTransformer("InterceptingMessageProcessor").process(event));
        }
    }

    static class TestNonIntercepting
    implements MessageProcessor {
        TestNonIntercepting() {
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            return new StringAppendTransformer("MessageProcessor").process(event);
        }
    }
}

