/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.routing.outbound.AbstractMessageSplitter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.routing.outbound.SplitMessage;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class MessageSplitterRouterTestCase
extends AbstractMuleTestCase {
    public MessageSplitterRouterTestCase() {
        this.setStartContext(true);
    }

    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)MessageSplitterRouterTestCase.getTestService());
        session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpointUri.1");
        OutboundEndpoint endpoint2 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2");
        OutboundEndpoint endpoint3 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        Mock mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        OutboundEndpoint endpoint4 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test4Endpoint", "test://endpointUri.4?exchangePattern=request-response");
        OutboundEndpoint endpoint5 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?exchangePattern=request-response");
        OutboundEndpoint endpoint6 = MessageSplitterRouterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?exchangePattern=request-response");
        Mock mockendpoint4 = RouterTestUtils.getMockEndpoint(endpoint4);
        Mock mockendpoint5 = RouterTestUtils.getMockEndpoint(endpoint5);
        Mock mockendpoint6 = RouterTestUtils.getMockEndpoint(endpoint6);
        AbstractMessageSplitter router = new AbstractMessageSplitter(){

            protected SplitMessage getMessageParts(MuleMessage message, List<MessageProcessor> endpoints) {
                int i = 0;
                SplitMessage splitMessage = new SplitMessage();
                StringTokenizer tokenizer = new StringTokenizer(message.getPayload().toString(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    splitMessage.addPart((Object)s, (OutboundEndpoint)endpoints.get(i));
                    ++i;
                }
                return splitMessage;
            }
        };
        router.setMuleContext(muleContext);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint3.proxy());
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test,mule,message", muleContext);
        MessageSplitterRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint3.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy()));
        mockendpoint1.verify();
        mockendpoint2.verify();
        mockendpoint3.verify();
        endpoints = new ArrayList();
        endpoints.add((OutboundEndpoint)mockendpoint4.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint5.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint6.proxy());
        router.getRoutes().clear();
        router.setRoutes(endpoints);
        message = new DefaultMuleMessage((Object)"test,mule,message", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        mockendpoint4.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint5.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint6.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy()));
        MessageSplitterRouterTestCase.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        MessageSplitterRouterTestCase.assertNotNull((Object)resultMessage);
        MessageSplitterRouterTestCase.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        MessageSplitterRouterTestCase.assertEquals((int)3, (int)((MuleMessageCollection)resultMessage).size());
        mockendpoint4.verify();
        mockendpoint5.verify();
        mockendpoint6.verify();
    }
}

