/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.LocaleMessageHandler;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.transformer.AbstractTransformerTestCase;
import org.mule.transformer.simple.ObjectArrayToString;
import org.mule.transformer.simple.StringToObjectArray;
import org.mule.transformer.types.DataTypeFactory;

public class StringToObjectArrayTestCase
extends AbstractTransformerTestCase {
    private String encoding = "Windows-31J";

    public Object getResultData() {
        return new String[]{this.getMessage("char0"), this.getMessage("char1"), this.getMessage("char2")};
    }

    public Object getTestData() {
        try {
            return this.getMessage("message").getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Transformer getTransformer() throws Exception {
        Transformer trans = (Transformer)this.createObject(StringToObjectArray.class);
        trans.setReturnDataType(DataTypeFactory.create(Object[].class));
        EndpointURIEndpointBuilder builder = new EndpointURIEndpointBuilder("test://test", muleContext);
        builder.setEncoding(this.encoding);
        InboundEndpoint endpoint = muleContext.getEndpointFactory().getInboundEndpoint((EndpointBuilder)builder);
        trans.setEndpoint((ImmutableEndpoint)endpoint);
        return trans;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return new ObjectArrayToString();
    }

    public boolean compareResults(Object expected, Object result) {
        return super.compareResults(expected, result);
    }

    public boolean compareRoundtripResults(Object expected, Object result) {
        try {
            return super.compareRoundtripResults(expected, ((String)result).getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getMessage(String key) {
        return LocaleMessageHandler.getString((String)"test-data", (Locale)Locale.JAPAN, (String)("StringToObjectArrayTestCase." + key), (Object[])new Object[0]);
    }
}

