/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import org.mule.DefaultMuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.wire.TransformerPairWireFormat;

public abstract class AbstractWireFormatTestCase
extends AbstractMuleTestCase {
    public void testWriteReadMessage() throws Exception {
        HashMap<String, String> messageProerties = new HashMap<String, String>();
        messageProerties.put("key1", "val1");
        DefaultMuleMessage inMessage = new DefaultMuleMessage((Object)"testMessage", messageProerties, muleContext);
        Object outMessage = this.readWrite(inMessage);
        AbstractWireFormatTestCase.assertTrue((boolean)(outMessage instanceof String));
        AbstractWireFormatTestCase.assertEquals((Object)"testMessage", (Object)outMessage);
    }

    public void testWriteReadPayload() throws Exception {
        Properties messageProerties = new Properties();
        messageProerties.put("key1", "val1");
        Orange inOrange = new Orange();
        inOrange.setBrand("Walmart");
        inOrange.setMapProperties(messageProerties);
        Object outObject = this.readWrite(inOrange);
        AbstractWireFormatTestCase.assertTrue((boolean)(outObject instanceof Orange));
        AbstractWireFormatTestCase.assertEquals((String)"Walmart", (String)((Orange)outObject).getBrand());
        AbstractWireFormatTestCase.assertEquals((Object)"val1", ((Orange)outObject).getMapProperties().get("key1"));
    }

    protected Object readWrite(Object inObject) throws Exception {
        WireFormat wireFormat = this.getWireFormat();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        wireFormat.write((OutputStream)out, inObject, "UTF-8");
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        Object outMessage = wireFormat.read((InputStream)in);
        AbstractWireFormatTestCase.assertNotNull((Object)outMessage);
        return outMessage;
    }

    public void testSetInboundTransformer() throws Exception {
        TransformerPairWireFormat transPairWireFormat = (TransformerPairWireFormat)this.getWireFormat();
        transPairWireFormat.setInboundTransformer((Transformer)new ObjectToString());
        AbstractWireFormatTestCase.assertTrue((boolean)(transPairWireFormat.getInboundTransformer() instanceof ObjectToString));
    }

    public void testSetOutboundTransformer() throws Exception {
        TransformerPairWireFormat transPairWireFormat = (TransformerPairWireFormat)this.getWireFormat();
        transPairWireFormat.setInboundTransformer((Transformer)new ObjectToString());
        AbstractWireFormatTestCase.assertTrue((boolean)(transPairWireFormat.getInboundTransformer() instanceof ObjectToString));
    }

    public abstract void testGetDefaultInboundTransformer() throws Exception;

    public abstract void testGetDefaultOutboundTransformer() throws Exception;

    protected abstract WireFormat getWireFormat() throws Exception;
}

