/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.log4j.lf5.util.StreamUtils;

public class CachedHttpServletRequest
extends HttpServletRequestWrapper {
    private CachedServletInputStream cachedServletInputStream;

    public CachedHttpServletRequest(HttpServletRequest request) {
        super(request);
        try {
            this.cachedServletInputStream = new CachedServletInputStream(request.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.cachedServletInputStream != null) {
            return this.cachedServletInputStream;
        }
        return super.getInputStream();
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private ByteArrayInputStream cachedStream;

        public CachedServletInputStream(ServletInputStream servletInputStream) {
            try {
                byte[] bytes = StreamUtils.getBytes((InputStream)servletInputStream);
                this.cachedStream = new ByteArrayInputStream(bytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int available() throws IOException {
            return this.cachedStream.available();
        }

        public void close() throws IOException {
            this.cachedStream.close();
        }

        protected void finalize() throws Throwable {
        }

        public synchronized void mark(int readlimit) {
            this.cachedStream.mark(readlimit);
        }

        public boolean markSupported() {
            return true;
        }

        public int read() throws IOException {
            return this.cachedStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.cachedStream.read(b, off, len);
        }

        public int read(byte[] b) throws IOException {
            return this.cachedStream.read(b);
        }

        public synchronized void reset() throws IOException {
            this.cachedStream.reset();
        }

        public long skip(long n) throws IOException {
            return this.cachedStream.skip(n);
        }
    }
}

