/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor.chain;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.processor.policy.AroundPolicy;
import org.mule.api.processor.policy.Policies;
import org.mule.api.processor.policy.PolicyInvocation;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageProcessorChain
extends AbstractInterceptingMessageProcessor
implements MessageProcessorChain,
Lifecycle,
FlowConstructAware,
MuleContextAware {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    protected String name;
    protected List<MessageProcessor> processors;
    private final Policies policies = new Policies(this);

    public AbstractMessageProcessorChain(String name, List<MessageProcessor> processors) {
        this.name = name;
        this.processors = processors;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Invoking %s with event %s", this, event));
        }
        if (event == null) {
            return null;
        }
        List<AroundPolicy> activePolicies = this.policies.list();
        if (!activePolicies.isEmpty()) {
            PolicyInvocation invocation = new PolicyInvocation(event, activePolicies, new MessageProcessor(){

                public MuleEvent process(MuleEvent event) throws MuleException {
                    return AbstractMessageProcessorChain.this.doProcess(event);
                }
            });
            AroundPolicy entryPoint = activePolicies.get(0);
            result = entryPoint.invoke(invocation);
        } else {
            result = this.doProcess(event);
        }
        return this.processNext(result);
    }

    protected abstract MuleEvent doProcess(MuleEvent var1) throws MuleException;

    @Override
    public void initialise() throws InitialisationException {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Initialisable)) continue;
            ((Initialisable)((Object)processor)).initialise();
        }
    }

    @Override
    public void start() throws MuleException {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Startable)) continue;
            ((Startable)((Object)processor)).start();
        }
    }

    @Override
    public void stop() throws MuleException {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Stoppable)) continue;
            ((Stoppable)((Object)processor)).stop();
        }
    }

    @Override
    public void dispose() {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof Disposable)) continue;
            ((Disposable)((Object)processor)).dispose();
        }
        this.processors.clear();
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof FlowConstructAware)) continue;
            ((FlowConstructAware)((Object)processor)).setFlowConstruct(flowConstruct);
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        for (MessageProcessor processor : this.processors) {
            if (!(processor instanceof MuleContextAware)) continue;
            ((MuleContextAware)((Object)processor)).setMuleContext(context);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.getClass().getSimpleName());
        if (StringUtils.isNotBlank((String)this.name)) {
            string.append(String.format(" '%s' ", this.name));
        }
        Iterator<MessageProcessor> mpIterator = this.processors.iterator();
        String nl = String.format("%n", new Object[0]);
        for (AroundPolicy policy : this.policies.list()) {
            string.append(String.format("%n  -- policy [%s]: %s", policy.getName(), policy));
        }
        if (mpIterator.hasNext()) {
            string.append(String.format("%n[ ", new Object[0]));
            while (mpIterator.hasNext()) {
                MessageProcessor mp = mpIterator.next();
                String indented = StringUtils.replace((String)mp.toString(), (String)nl, (String)String.format("%n  ", new Object[0]));
                string.append(String.format("%n  %s", indented));
                if (!mpIterator.hasNext()) continue;
                string.append(", ");
            }
            string.append(String.format("%n]", new Object[0]));
        }
        return string.toString();
    }

    @Override
    public List<MessageProcessor> getMessageProcessors() {
        return this.processors;
    }

    @Override
    public Policies getPolicies() {
        return this.policies;
    }
}

