/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.types;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.DataType;
import org.mule.transformer.types.CollectionDataType;
import org.mule.transformer.types.ImmutableDataType;
import org.mule.transformer.types.SimpleDataType;
import org.mule.util.generics.GenericsUtils;
import org.mule.util.generics.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeFactory {
    public static final DataType<String> TEXT_STRING = new SimpleDataType<String>(String.class, "text/plain");
    public static final DataType<String> XML_STRING = new SimpleDataType<String>(String.class, "text/xml");
    public static final DataType<String> JSON_STRING = new SimpleDataType<String>(String.class, "application/json");
    public static final DataType<String> HTML_STRING = new SimpleDataType<String>(String.class, "text/html");
    public static final DataType<String> ATOM_STRING = new SimpleDataType<String>(String.class, "application/atom+xml");
    public static final DataType<String> RSS_STRING = new SimpleDataType<String>(String.class, "application/rss+xml");
    public static final DataType<String> STRING = new SimpleDataType<String>(String.class);
    public static final DataType<String> OBJECT = new SimpleDataType<String>(Object.class);
    public static final DataType<String> BYTE_ARRAY = new SimpleDataType<String>(byte[].class);
    public static final DataType<String> INPUT_STREAM = new SimpleDataType<String>(InputStream.class);
    public static final DataType<String> MULE_MESSAGE = new SimpleDataType<String>(MuleMessage.class);
    private static ConcurrentHashMap proxyClassCache = new ConcurrentHashMap();

    public static <T> DataType<T> create(Class<T> type) {
        return DataTypeFactory.create(type, "*/*");
    }

    public static <T> DataType<T> createImmutable(Class<T> type) {
        return new ImmutableDataType<T>(DataTypeFactory.create(type, "*/*"));
    }

    public static <T> DataType<T> createWithEncoding(Class<T> type, String encoding) {
        DataType<T> dataType = DataTypeFactory.create(type);
        dataType.setEncoding(encoding);
        return dataType;
    }

    public static <T> DataType<T> create(Class<T> type, String mimeType) {
        if (Collection.class.isAssignableFrom(type)) {
            Class<T> collectionType = type;
            Class<?> itemType = GenericsUtils.getCollectionType(collectionType);
            if (itemType == null) {
                return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)collectionType), mimeType);
            }
            return new CollectionDataType(collectionType, itemType, mimeType);
        }
        if (DataTypeFactory.isProxyClass(type)) {
            return new SimpleDataType(type.getInterfaces()[0], mimeType);
        }
        return new SimpleDataType(type, mimeType);
    }

    public static <T> DataType create(Class<? extends Collection> collClass, Class<T> itemType) {
        return DataTypeFactory.create(collClass, itemType, null);
    }

    public static <T> DataType create(Class<? extends Collection> collClass, Class<T> itemType, String mimeType) {
        return new CollectionDataType(collClass, itemType, mimeType);
    }

    public static DataType<?> createFromObject(Object o) {
        int i;
        Class<?> type = o.getClass();
        String mime = null;
        if (o instanceof DataType) {
            return (DataType)o;
        }
        if (o instanceof MuleMessage) {
            MuleMessage mm = (MuleMessage)o;
            type = mm.getPayload().getClass();
            mime = (String)mm.getInboundProperty("Content-Type");
            if (mime == null) {
                mime = (String)mm.getInboundProperty("ContentType");
            }
        } else if (o instanceof DataHandler) {
            mime = ((DataHandler)o).getContentType();
        } else if (o instanceof DataSource) {
            mime = ((DataSource)o).getContentType();
        }
        mime = mime != null ? ((i = mime.indexOf(";")) > -1 ? mime.substring(0, i) : mime) : "*/*";
        return DataTypeFactory.create(type, mime);
    }

    public static DataType<?> createFromReturnType(Method m) {
        return DataTypeFactory.createFromReturnType(m, null);
    }

    public static DataType<?> createFromReturnType(Method m, String mimeType) {
        if (Collection.class.isAssignableFrom(m.getReturnType())) {
            Class<?> cType = m.getReturnType();
            Class<?> itemType = GenericsUtils.getCollectionReturnType(m);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(m.getReturnType(), mimeType);
    }

    public static DataType createFromParameterType(Method m, int paramIndex) {
        return DataTypeFactory.createFromParameterType(m, paramIndex, null);
    }

    public static DataType createFromParameterType(Method m, int paramIndex, String mimeType) {
        if (Collection.class.isAssignableFrom(m.getParameterTypes()[paramIndex])) {
            Class<?> cType = m.getParameterTypes()[paramIndex];
            Class<?> itemType = GenericsUtils.getCollectionParameterType(new MethodParameter(m, paramIndex));
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(m.getParameterTypes()[paramIndex], mimeType);
    }

    public static DataType<?> createFromField(Field f) {
        return DataTypeFactory.createFromField(f, null);
    }

    public static DataType<?> createFromField(Field f, String mimeType) {
        if (Collection.class.isAssignableFrom(f.getType())) {
            Class<?> cType = f.getType();
            Class<?> itemType = GenericsUtils.getCollectionFieldType(f);
            if (itemType != null) {
                return new CollectionDataType(cType, itemType, mimeType);
            }
            return new CollectionDataType((Class<? extends Collection>)((Class<Collection>)cType), mimeType);
        }
        return new SimpleDataType(f.getType(), mimeType);
    }

    protected static <T> boolean isProxyClass(Class<T> type) {
        String typeName = type.getName();
        ProxyIndicator indicator = (ProxyIndicator)proxyClassCache.get((Object)typeName);
        if (indicator != null) {
            Class classInMap = indicator.getTargetClass();
            if (classInMap == type) {
                return indicator.isProxy();
            }
            if (classInMap != null) {
                return Proxy.isProxyClass(type);
            }
        }
        boolean isProxy = Proxy.isProxyClass(type);
        class ProxyIndicator {
            private final WeakReference<Class> targetClassRef;
            private final boolean isProxy;

            ProxyIndicator(Class targetClass, boolean proxy) {
                this.targetClassRef = new WeakReference<Class>(targetClass);
                this.isProxy = proxy;
            }

            public Class getTargetClass() {
                return (Class)this.targetClassRef.get();
            }

            public boolean isProxy() {
                return this.isProxy;
            }
        }
        proxyClassCache.put((Object)typeName, (Object)new ProxyIndicator(type, isProxy));
        return isProxy;
    }
}

