/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.lob;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.util.List;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.id.DbidGenerator;
import org.jbpm.pvm.internal.lob.BlobStrategy;
import org.jbpm.pvm.internal.lob.BlobStrategyBlob;
import org.jbpm.pvm.internal.lob.BytesChop;
import org.jbpm.pvm.internal.lob.CharChop;
import org.jbpm.pvm.internal.lob.ClobStrategy;
import org.jbpm.pvm.internal.lob.ClobStrategyChopped;

public class Lob
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final BlobStrategy DEFAULT_BLOB_STRATEGY = new BlobStrategyBlob();
    public static final ClobStrategy DEFAULT_CLOB_STRATEGY = new ClobStrategyChopped();
    protected long dbid;
    protected int dbversion;
    protected byte[] cachedBytes = null;
    protected Blob blob = null;
    protected byte[] bytes = null;
    protected List<BytesChop> bytesChops = null;
    protected char[] cachedChars = null;
    protected Clob clob = null;
    protected String text = null;
    protected List<CharChop> charChops = null;

    public long getDbid() {
        return this.dbid;
    }

    public void setDbid(long dbid) {
        this.dbid = dbid;
    }

    public Lob() {
    }

    public Lob(byte[] bytes, boolean generateDbid) {
        this.cachedBytes = bytes;
        this.getBlobStrategy().set(bytes, this);
        if (generateDbid) {
            this.dbid = DbidGenerator.getDbidGenerator().getNextId();
        }
    }

    public Lob(char[] text, boolean generateDbid) {
        this.cachedChars = text;
        this.getClobStrategy().set(text, this);
        if (generateDbid) {
            this.dbid = DbidGenerator.getDbidGenerator().getNextId();
        }
    }

    public char[] extractChars() {
        return this.getClobStrategy().get(this);
    }

    public byte[] extractBytes() {
        return this.getBlobStrategy().get(this);
    }

    protected ClobStrategy getClobStrategy() {
        ClobStrategy clobStrategy = null;
        EnvironmentImpl environment = EnvironmentImpl.getCurrent();
        if (environment != null) {
            clobStrategy = environment.get(ClobStrategy.class);
        }
        if (clobStrategy == null) {
            clobStrategy = DEFAULT_CLOB_STRATEGY;
        }
        return clobStrategy;
    }

    protected BlobStrategy getBlobStrategy() {
        BlobStrategy blobStrategy = EnvironmentImpl.getFromCurrent(BlobStrategy.class, false);
        if (blobStrategy == null) {
            blobStrategy = DEFAULT_BLOB_STRATEGY;
        }
        return blobStrategy;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.cachedBytes != null) {
            this.getBlobStrategy().set(this.cachedBytes, this);
        }
        if (this.cachedChars != null) {
            this.getClobStrategy().set(this.cachedChars, this);
        }
        return this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.blob = null;
        this.clob = null;
        return this;
    }
}

