/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Wss11;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS11Builder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.WSS11, SP12Constants.WSS11);

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        Wss11 wss11 = new Wss11(consts);
        this.processAlternative(element, wss11, consts);
        return wss11;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    private void processAlternative(Element element, Wss11 parent, SPConstants consts) {
        Element polEl = PolicyConstants.findPolicyElement((Element)element);
        if (polEl != null) {
            Element child = DOMUtils.getFirstElement((Node)polEl);
            while (child != null) {
                String name = child.getLocalName();
                if ("MustSupportRefKeyIdentifier".equals(name)) {
                    parent.setMustSupportRefKeyIdentifier(true);
                } else if ("MustSupportRefIssuerSerial".equals(name)) {
                    parent.setMustSupportRefIssuerSerial(true);
                } else if ("MustSupportRefExternalURI".equals(name)) {
                    parent.setMustSupportRefExternalURI(true);
                } else if ("MustSupportRefEmbeddedToken".equals(name)) {
                    parent.setMustSupportRefEmbeddedToken(true);
                } else if ("MustSupportRefThumbprint".equals(name)) {
                    parent.setMustSupportRefThumbprint(true);
                } else if ("MustSupportRefEncryptedKey".equals(name)) {
                    parent.setMustSupportRefEncryptedKey(true);
                } else if ("RequireSignatureConfirmation".equals(name)) {
                    parent.setRequireSignatureConfirmation(true);
                }
                child = DOMUtils.getNextElement((Element)child);
            }
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

