/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http.multipart;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class MultiPartOutputStream
extends FilterOutputStream {
    private static byte[] __CRLF;
    private static byte[] __DASHDASH;
    private String encoding;
    private String boundary;
    private byte[] boundaryBytes;
    private boolean inPart = false;

    public MultiPartOutputStream(OutputStream out, String encoding) throws IOException {
        super(out);
        this.encoding = encoding;
        __CRLF = "\r\n".getBytes(encoding);
        __DASHDASH = "--".getBytes(encoding);
        this.boundary = "mule" + System.identityHashCode(this) + Long.toString(System.currentTimeMillis(), 36);
        this.boundaryBytes = this.boundary.getBytes(encoding);
        this.inPart = false;
    }

    public void close() throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__DASHDASH);
        this.out.write(__CRLF);
        this.inPart = false;
        super.close();
    }

    public String getBoundary() {
        return this.boundary;
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void startPart(String contentType) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(this.encoding));
        this.out.write(__CRLF);
        this.out.write(__CRLF);
    }

    public void startPart(String contentType, String[] headers) throws IOException {
        if (this.inPart) {
            this.out.write(__CRLF);
        }
        this.inPart = true;
        this.out.write(__DASHDASH);
        this.out.write(this.boundaryBytes);
        this.out.write(__CRLF);
        this.out.write(("Content-Type: " + contentType).getBytes(this.encoding));
        this.out.write(__CRLF);
        for (int i = 0; headers != null && i < headers.length; ++i) {
            this.out.write(headers[i].getBytes(this.encoding));
            this.out.write(__CRLF);
        }
        this.out.write(__CRLF);
    }
}

