/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom4j.Dom4jXPath;
import org.jaxen.javabean.JavaBeanXPath;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.registry.RegistrationException;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.util.NamespaceManager;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.ClassUtils;

public class JaxenFilter
implements Filter,
MuleContextAware {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String pattern;
    private String expectedValue;
    private Map namespaces = null;
    private Map contextProperties = null;
    private AbstractFactory factory;
    private MuleContext muleContext;
    private NamespaceManager namespaceManager;

    public JaxenFilter() {
    }

    public JaxenFilter(String pattern) {
        this.pattern = pattern;
    }

    public JaxenFilter(String pattern, String expectedValue) {
        this.pattern = pattern;
        this.expectedValue = expectedValue;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        try {
            this.namespaceManager = (NamespaceManager)this.muleContext.getRegistry().lookupObject(NamespaceManager.class);
        }
        catch (RegistrationException e) {
            throw new ExpressionRuntimeException(CoreMessages.failedToLoad((String)"NamespaceManager"), (Throwable)e);
        }
        if (this.namespaceManager != null) {
            if (this.namespaces == null) {
                this.namespaces = new HashMap(this.namespaceManager.getNamespaces());
            } else {
                this.namespaces.putAll(this.namespaceManager.getNamespaces());
            }
        }
    }

    public boolean accept(MuleMessage obj) {
        Object payload = obj.getPayload();
        try {
            if (payload instanceof DOMSource) {
                this.accept(((DOMSource)payload).getNode());
            } else if (payload instanceof byte[] || payload instanceof InputStream || payload instanceof String) {
                try {
                    return this.accept(obj.getPayload(DataTypeFactory.create(org.w3c.dom.Document.class)));
                }
                catch (Exception e) {
                    this.logger.warn((Object)("JaxenPath filter rejected message because it could not convert from " + payload.getClass() + " to Source: " + e.getMessage()), (Throwable)e);
                    return false;
                }
            }
            return this.accept(payload);
        }
        catch (JaxenException e) {
            this.logger.warn((Object)"JaxenPath filter rejected message because it could not build/evaluate the XPath expression.", (Throwable)e);
            return false;
        }
    }

    private boolean accept(Object obj) throws JaxenException {
        Document dom4jDoc;
        if (obj == null) {
            this.logger.warn((Object)"Applying JaxenFilter to null object.");
            return false;
        }
        if (this.pattern == null) {
            this.logger.warn((Object)"Expression for JaxenFilter is not set.");
            return false;
        }
        if (this.expectedValue == null) {
            if (this.pattern.endsWith("= null") || this.pattern.endsWith("=null")) {
                this.expectedValue = "null";
                this.pattern = this.pattern.substring(0, this.pattern.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)"Expected value for JaxenFilter is not set, using 'true' by default");
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        String xpathResult = null;
        boolean accept = false;
        try {
            dom4jDoc = XMLUtils.toDocument(obj, this.muleContext);
        }
        catch (Exception e) {
            throw new JaxenException((Throwable)e);
        }
        if (dom4jDoc != null) {
            xpathResult = this.getDom4jXPath().stringValueOf((Object)dom4jDoc);
        } else if (obj instanceof DOMSource) {
            xpathResult = this.getDOMXPath().stringValueOf(obj);
        } else if (obj instanceof org.w3c.dom.Document) {
            xpathResult = this.getDOMXPath().stringValueOf(obj);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Passing object of type " + obj.getClass().getName() + " to JaxenContext"));
            }
            xpathResult = this.getJavaBeanXPath().stringValueOf(obj);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JaxenFilter Expression result = '" + xpathResult + "' -  Expected value = '" + this.expectedValue + "'"));
        }
        if (xpathResult != null) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if (this.expectedValue.equals("null")) {
            accept = true;
        } else {
            this.logger.warn((Object)("JaxenFilter expression evaluates to null: " + this.pattern));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("JaxenFilter accept object  : " + accept));
        }
        return accept;
    }

    protected DOMXPath getDOMXPath() throws JaxenException {
        DOMXPath xpath = new DOMXPath(this.pattern);
        this.setupNamespaces((BaseXPath)xpath);
        return xpath;
    }

    protected Dom4jXPath getDom4jXPath() throws JaxenException {
        Dom4jXPath xpath = new Dom4jXPath(this.pattern);
        this.setupNamespaces((BaseXPath)xpath);
        return xpath;
    }

    protected JavaBeanXPath getJavaBeanXPath() throws JaxenException {
        JavaBeanXPath xpath = new JavaBeanXPath(this.pattern);
        this.setupNamespaces((BaseXPath)xpath);
        return xpath;
    }

    private void setupNamespaces(BaseXPath xpath) throws JaxenException {
        if (this.namespaces != null) {
            for (Map.Entry entry : this.namespaces.entrySet()) {
                xpath.addNamespace((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    public AbstractFactory getFactory() {
        return this.factory;
    }

    public void setFactory(AbstractFactory factory) {
        this.factory = factory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JaxenFilter other = (JaxenFilter)obj;
        return ClassUtils.equal((Object)this.expectedValue, (Object)other.expectedValue) && ClassUtils.equal((Object)this.contextProperties, (Object)other.contextProperties) && ClassUtils.equal((Object)this.namespaces, (Object)other.namespaces) && ClassUtils.equal((Object)this.pattern, (Object)other.pattern);
    }

    public int hashCode() {
        return ClassUtils.hash((Object[])new Object[]{this.getClass(), this.expectedValue, this.contextProperties, this.namespaces, this.pattern});
    }
}

