/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.sftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.transport.sftp.ErrorOccurredDecorator;
import org.mule.util.FileUtils;

public class SftpFileArchiveInputStream
extends FileInputStream
implements ErrorOccurredDecorator {
    private static final Log logger = LogFactory.getLog(SftpFileArchiveInputStream.class);
    private File file;
    private File archiveFile;
    private boolean errorOccured = false;
    private static final int LOG_BYTE_INTERVAL = 10000000;
    private long bytesRead = 0L;
    private long nextLevelToLogBytesRead = 10000000L;

    public SftpFileArchiveInputStream(File file) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.archiveFile = null;
    }

    public SftpFileArchiveInputStream(File file, File archiveFile) throws FileNotFoundException {
        super(file);
        this.file = file;
        this.archiveFile = archiveFile;
    }

    public int read() throws IOException {
        this.logReadBytes(1);
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.logReadBytes(len);
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.logReadBytes(b.length);
        return super.read(b);
    }

    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Closing the stream for the file " + this.file));
        }
        super.close();
        if (!this.errorOccured && this.archiveFile != null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Move archiveTmpSendingFile (" + this.file + ") to archiveFolder (" + this.archiveFile + ")..."));
            }
            FileUtils.moveFile((File)this.file, (File)this.archiveFile);
        }
    }

    public void setErrorOccurred() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setErrorOccurred() called");
        }
        this.errorOccured = true;
    }

    private void logReadBytes(int newBytesRead) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        this.bytesRead += (long)newBytesRead;
        if (this.bytesRead >= this.nextLevelToLogBytesRead) {
            logger.debug((Object)("Read " + this.bytesRead + " bytes and couting..."));
            this.nextLevelToLogBytesRead += 10000000L;
        }
    }
}

