/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.afterinvocation;

import java.util.Iterator;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class BasicAclEntryAfterInvocationProvider
implements AfterInvocationProvider,
InitializingBean,
MessageSourceAware {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider == null ? (class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider = BasicAclEntryAfterInvocationProvider.class$("org.acegisecurity.afterinvocation.BasicAclEntryAfterInvocationProvider")) : class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider));
    private AclManager aclManager;
    private Class processDomainObjectClass = class$java$lang$Object == null ? (class$java$lang$Object = BasicAclEntryAfterInvocationProvider.class$("java.lang.Object")) : class$java$lang$Object;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private String processConfigAttribute = "AFTER_ACL_READ";
    private int[] requirePermission = new int[]{SimpleAclEntry.READ};
    static /* synthetic */ Class class$org$acegisecurity$afterinvocation$BasicAclEntryAfterInvocationProvider;
    static /* synthetic */ Class class$java$lang$Object;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.processConfigAttribute, (String)"A processConfigAttribute is mandatory");
        Assert.notNull((Object)this.aclManager, (String)"An aclManager is mandatory");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        if (this.requirePermission == null || this.requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attr = (ConfigAttribute)iter.next();
            if (!this.supports(attr)) continue;
            if (returnedObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is null, skipping");
                }
                return null;
            }
            if (!this.processDomainObjectClass.isAssignableFrom(returnedObject.getClass())) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Return object is not applicable for this provider, skipping");
                }
                return null;
            }
            AclEntry[] acls = this.aclManager.getAcls(returnedObject, authentication);
            if (acls == null || acls.length == 0) {
                throw new AccessDeniedException(this.messages.getMessage("BasicAclEntryAfterInvocationProvider.noPermission", new Object[]{authentication.getName(), returnedObject}, "Authentication {0} has NO permissions at all to the domain object {1}", LocaleContextHolder.getLocale()));
            }
            for (int i = 0; i < acls.length; ++i) {
                if (!(acls[i] instanceof BasicAclEntry)) continue;
                BasicAclEntry processableAcl = (BasicAclEntry)acls[i];
                for (int y = 0; y < this.requirePermission.length; ++y) {
                    if (!processableAcl.isPermitted(this.requirePermission[y])) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Principal DOES have permission to return object: " + returnedObject + " due to ACL: " + processableAcl.toString()));
                    }
                    return returnedObject;
                }
            }
            throw new AccessDeniedException(this.messages.getMessage("BasicAclEntryAfterInvocationProvider.insufficientPermission", new Object[]{authentication.getName(), returnedObject}, "Authentication {0} has ACL permissions to the domain object, but not the required ACL permission to the domain object {1}", LocaleContextHolder.getLocale()));
        }
        return returnedObject;
    }

    public AclManager getAclManager() {
        return this.aclManager;
    }

    public String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public int[] getRequirePermission() {
        return this.requirePermission;
    }

    public void setAclManager(AclManager aclManager) {
        this.aclManager = aclManager;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setProcessConfigAttribute(String processConfigAttribute) {
        this.processConfigAttribute = processConfigAttribute;
    }

    public void setProcessDomainObjectClass(Class processDomainObjectClass) {
        Assert.notNull((Object)processDomainObjectClass, (String)"processDomainObjectClass cannot be set to null");
        this.processDomainObjectClass = processDomainObjectClass;
    }

    public void setRequirePermission(int[] requirePermission) {
        this.requirePermission = requirePermission;
    }

    public void setRequirePermissionFromString(String[] requiredPermissions) {
        this.setRequirePermission(SimpleAclEntry.parsePermissions(requiredPermissions));
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    public boolean supports(Class clazz) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

