/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.file;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connectable;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.config.i18n.Message;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.ConnectException;
import org.mule.transport.file.FileConnector;
import org.mule.transport.file.FileContentsMuleMessageFactory;
import org.mule.transport.file.ReceiverFileInputStream;
import org.mule.transport.file.i18n.FileMessages;
import org.mule.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMessageReceiver
extends AbstractPollingMessageReceiver {
    public static final String COMPARATOR_CLASS_NAME_PROPERTY = "comparator";
    public static final String COMPARATOR_REVERSE_ORDER_PROPERTY = "reverseOrder";
    private static final List<File> NO_FILES = new ArrayList<File>();
    private String readDir = null;
    private String moveDir = null;
    private String workDir = null;
    private File readDirectory = null;
    private File moveDirectory = null;
    private String moveToPattern = null;
    private String workFileNamePattern = null;
    private FilenameFilter filenameFilter = null;
    private FileFilter fileFilter = null;
    private boolean forceSync;

    public FileMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint, String readDir, String moveDir, String moveToPattern, long frequency) throws CreateException {
        super(connector, flowConstruct, endpoint);
        this.setFrequency(frequency);
        this.readDir = readDir;
        this.moveDir = moveDir;
        this.moveToPattern = moveToPattern;
        this.workDir = ((FileConnector)connector).getWorkDirectory();
        this.workFileNamePattern = ((FileConnector)connector).getWorkFileNamePattern();
        if (endpoint.getFilter() instanceof FilenameFilter) {
            this.filenameFilter = (FilenameFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() instanceof FileFilter) {
            this.fileFilter = (FileFilter)endpoint.getFilter();
        } else if (endpoint.getFilter() != null) {
            throw new CreateException(FileMessages.invalidFileFilter(endpoint.getEndpointURI()), (Object)this);
        }
        this.checkMustForceSync(endpoint);
    }

    private void checkMustForceSync(InboundEndpoint endpoint) throws CreateException {
        boolean connectorIsAutoDelete = false;
        boolean isStreaming = false;
        if (this.connector instanceof FileConnector) {
            connectorIsAutoDelete = ((FileConnector)this.connector).isAutoDelete();
            isStreaming = ((FileConnector)this.connector).isStreaming();
        }
        boolean messageFactoryConsumes = this.createMuleMessageFactory() instanceof FileContentsMuleMessageFactory;
        this.forceSync = connectorIsAutoDelete && !messageFactoryConsumes && !isStreaming;
    }

    protected void doConnect() throws Exception {
        if (this.readDir != null) {
            this.readDirectory = FileUtils.openDirectory((String)this.readDir);
            if (!this.readDirectory.canRead()) {
                throw new ConnectException(FileMessages.fileDoesNotExist(this.readDirectory.getAbsolutePath()), (Connectable)this);
            }
            this.logger.debug((Object)("Listening on endpointUri: " + this.readDirectory.getAbsolutePath()));
        }
        if (this.moveDir != null) {
            this.moveDirectory = FileUtils.openDirectory((String)this.moveDir);
            if (!this.moveDirectory.canRead() || !this.moveDirectory.canWrite()) {
                throw new ConnectException(FileMessages.moveToDirectoryNotWritable(), (Connectable)this);
            }
        }
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doDispose() {
    }

    public void poll() {
        try {
            Comparator<File> comparator;
            List<File> files = this.listFiles();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Files: " + files.toString()));
            }
            if ((comparator = this.getComparator()) != null) {
                Collections.sort(files, comparator);
            }
            for (File file : files) {
                if (!this.getLifecycleState().isStopping()) {
                    if (!file.isFile()) continue;
                    this.processFile(file);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.getConnector().getMuleContext().getExceptionListener().handleException(e);
        }
    }

    public void processFile(File sourceFile) throws MuleException {
        FileConnector fileConnector = (FileConnector)this.connector;
        boolean checkFileAge = fileConnector.getCheckFileAge();
        if (checkFileAge) {
            long fileAge = ((FileConnector)this.connector).getFileAge();
            long lastMod = sourceFile.lastModified();
            long now = System.currentTimeMillis();
            long thisFileAge = now - lastMod;
            if (thisFileAge < fileAge) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("The file has not aged enough yet, will return nothing for: " + sourceFile));
                }
                return;
            }
        }
        String sourceFileOriginalName = sourceFile.getName();
        if (!(sourceFile.canRead() && sourceFile.exists() && sourceFile.isFile())) {
            throw new DefaultMuleException(FileMessages.fileDoesNotExist(sourceFileOriginalName));
        }
        if (!this.attemptFileLock(sourceFile)) {
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Lock obtained on file: " + sourceFile.getAbsolutePath()));
        }
        DefaultMuleMessage fileParserMessasge = new DefaultMuleMessage(null, this.connector.getMuleContext());
        fileParserMessasge.setOutboundProperty("originalFilename", (Object)sourceFileOriginalName);
        File workFile = null;
        if (this.workDir != null) {
            String workFileName = sourceFileOriginalName;
            workFileName = fileConnector.getFilenameParser().getFilename((MuleMessage)fileParserMessasge, this.workFileNamePattern);
            workFile = FileUtils.newFile((String)this.workDir, (String)workFileName);
            this.move(sourceFile, workFile);
            sourceFile = workFile;
        }
        File destinationFile = null;
        if (this.moveDir != null) {
            String destinationFileName = sourceFileOriginalName;
            if (this.moveToPattern != null) {
                destinationFileName = ((FileConnector)this.connector).getFilenameParser().getFilename((MuleMessage)fileParserMessasge, this.moveToPattern);
            }
            destinationFile = FileUtils.newFile((String)this.moveDir, (String)destinationFileName);
        }
        MuleMessage message = null;
        String encoding = this.endpoint.getEncoding();
        try {
            if (fileConnector.isStreaming()) {
                ReceiverFileInputStream payload = new ReceiverFileInputStream(sourceFile, fileConnector.isAutoDelete(), destinationFile);
                message = this.createMuleMessage(payload, encoding);
            } else {
                message = this.createMuleMessage(sourceFile, encoding);
            }
        }
        catch (FileNotFoundException e) {
            this.logger.error((Object)"File being read disappeared!", (Throwable)e);
            return;
        }
        message.setOutboundProperty("originalFilename", (Object)sourceFileOriginalName);
        if (this.forceSync) {
            message.setProperty("MULE_FORCE_SYNC", (Object)Boolean.TRUE, PropertyScope.INBOUND);
        }
        if (!fileConnector.isStreaming()) {
            this.moveAndDelete(sourceFile, destinationFile, sourceFileOriginalName, message);
        } else {
            message.setOutboundProperty("filename", (Object)sourceFile.getName());
            this.routeMessage(message);
        }
    }

    private void moveAndDelete(File sourceFile, File destinationFile, String sourceFileOriginalName, MuleMessage message) {
        boolean fileWasMoved = false;
        try {
            if (destinationFile != null) {
                try {
                    FileUtils.moveFile((File)sourceFile, (File)destinationFile);
                }
                catch (IOException e) {
                    throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
                }
                message = this.createMuleMessage(destinationFile, this.endpoint.getEncoding());
                message.setOutboundProperty("filename", (Object)destinationFile.getName());
                message.setOutboundProperty("originalFilename", (Object)sourceFileOriginalName);
            }
            this.routeMessage(message);
            if (((FileConnector)this.connector).isAutoDelete() && destinationFile == null && !sourceFile.delete()) {
                throw new DefaultMuleException(FileMessages.failedToDeleteFile(sourceFile));
            }
        }
        catch (Exception e) {
            boolean fileWasRolledBack = false;
            if (fileWasMoved) {
                try {
                    this.rollbackFileMove(destinationFile, sourceFile.getAbsolutePath());
                    fileWasRolledBack = true;
                }
                catch (IOException ioException) {
                    // empty catch block
                }
            }
            Message msg = FileMessages.exceptionWhileProcessing(sourceFile.getName(), fileWasRolledBack ? "successful" : "unsuccessful");
            this.getConnector().getMuleContext().getExceptionListener().handleException((Exception)new MessagingException(msg, message, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attemptFileLock(File sourceFile) throws MuleException {
        FileLock lock = null;
        FileChannel channel = null;
        boolean fileCanBeLocked = false;
        try {
            channel = new RandomAccessFile(sourceFile, "rw").getChannel();
            lock = channel.tryLock();
        }
        catch (FileNotFoundException fnfe) {
            throw new DefaultMuleException(FileMessages.fileDoesNotExist(sourceFile.getName()));
        }
        catch (IOException e) {
        }
        finally {
            if (lock != null) {
                fileCanBeLocked = true;
                try {
                    lock.release();
                }
                catch (IOException e) {}
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {}
            }
        }
        return fileCanBeLocked;
    }

    List<File> listFiles() throws MuleException {
        try {
            ArrayList<File> files = new ArrayList<File>();
            this.basicListFiles(this.readDirectory, files);
            return files.isEmpty() ? NO_FILES : files;
        }
        catch (Exception e) {
            throw new DefaultMuleException(FileMessages.errorWhileListingFiles(), (Throwable)e);
        }
    }

    protected void basicListFiles(File currentDirectory, List<File> discoveredFiles) {
        File[] files = this.fileFilter != null ? currentDirectory.listFiles(this.fileFilter) : currentDirectory.listFiles(this.filenameFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) {
                discoveredFiles.add(file);
                continue;
            }
            if (!((FileConnector)this.getConnector()).isRecursive()) continue;
            this.basicListFiles(file, discoveredFiles);
        }
    }

    protected void rollbackFileMove(File sourceFile, String destinationFilePath) throws IOException {
        try {
            FileUtils.moveFile((File)sourceFile, (File)FileUtils.newFile((String)destinationFilePath));
        }
        catch (IOException t) {
            this.logger.debug((Object)("rollback of file move failed: " + t.getMessage()));
            throw t;
        }
    }

    protected Comparator<File> getComparator() throws Exception {
        Object comparatorClassName = this.getEndpoint().getProperty((Object)COMPARATOR_CLASS_NAME_PROPERTY);
        if (comparatorClassName != null) {
            Object reverseProperty = this.getEndpoint().getProperty((Object)COMPARATOR_REVERSE_ORDER_PROPERTY);
            boolean reverse = false;
            if (reverseProperty != null) {
                reverse = Boolean.valueOf((String)reverseProperty);
            }
            Class<?> clazz = Class.forName(comparatorClassName.toString());
            Comparator comparator = (Comparator)clazz.newInstance();
            return reverse ? new ReverseComparator(comparator) : comparator;
        }
        return null;
    }

    private void move(File sourceFile, File destinationFile) throws DefaultMuleException {
        boolean fileWasMoved;
        if (destinationFile != null && !(fileWasMoved = sourceFile.renameTo(destinationFile))) {
            throw new DefaultMuleException(FileMessages.failedToMoveFile(sourceFile.getAbsolutePath(), destinationFile.getAbsolutePath()));
        }
    }
}

