/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.reboot;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMuleClassPathConfig {
    protected static final String MULE_DIR = "/lib/mule";
    protected static final String USER_DIR = "/lib/user";
    protected static final String OPT_DIR = "/lib/opt";
    protected List<URL> urls = new ArrayList<URL>();

    public DefaultMuleClassPathConfig(File muleHome, File muleBase) {
        this.init(muleHome, muleBase);
    }

    protected void init(File muleHome, File muleBase) {
        this.addMuleBaseUserLibs(muleHome, muleBase);
        this.addLibraryDirectory(muleHome, USER_DIR);
        this.addLibraryDirectory(muleHome, MULE_DIR);
        this.addLibraryDirectory(muleHome, OPT_DIR);
    }

    protected void addMuleBaseUserLibs(File muleHome, File muleBase) {
        try {
            if (!muleHome.getCanonicalFile().equals(muleBase.getCanonicalFile())) {
                File userOverrideDir = new File(muleBase, USER_DIR);
                this.addFile(userOverrideDir);
                this.addFiles(this.listJars(userOverrideDir));
            }
        }
        catch (IOException ioe) {
            System.out.println("Unable to check to see if there are local jars to load: " + ioe.toString());
        }
    }

    protected void addLibraryDirectory(File muleHome, String libDirectory) {
        File directory = new File(muleHome, libDirectory);
        this.addFile(directory);
        this.addFiles(this.listJars(directory));
    }

    public List<URL> getURLs() {
        return new ArrayList<URL>(this.urls);
    }

    public void addURLs(List<URL> moreUrls) {
        if (moreUrls != null && !moreUrls.isEmpty()) {
            this.urls.addAll(moreUrls);
        }
    }

    public void addURL(URL url) {
        this.urls.add(url);
    }

    public void addFiles(List<File> files) {
        Iterator<File> i = files.iterator();
        while (i.hasNext()) {
            this.addFile(i.next());
        }
    }

    public void addFile(File jar) {
        try {
            this.addURL(jar.getAbsoluteFile().toURI().toURL());
        }
        catch (MalformedURLException mux) {
            throw new RuntimeException("Failed to construct a classpath URL", mux);
        }
    }

    protected List<File> listJars(File path) {
        File[] jars = path.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                try {
                    return pathname.getCanonicalPath().endsWith(".jar");
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        });
        if (jars != null) {
            return Arrays.asList(jars);
        }
        return Collections.emptyList();
    }
}

