/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.CouldNotRouteOutboundMessageException;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.outbound.AbstractOutboundRouter;

public class FirstSuccessful
extends AbstractOutboundRouter {
    protected String failureExpression;
    protected ExpressionFilter failureExpressionFilter;

    public void initialise() throws InitialisationException {
        super.initialise();
        this.failureExpressionFilter = this.failureExpression != null ? new ExpressionFilter(this.failureExpression) : new ExpressionFilter("exception-type:");
        this.failureExpressionFilter.setMuleContext(this.muleContext);
    }

    public MuleEvent route(MuleEvent event) throws MessagingException {
        MuleEvent returnEvent = null;
        boolean failed = true;
        for (MessageProcessor mp : this.routes) {
            try {
                MuleMessage msg;
                MuleMessage clonedMessage = this.cloneMessage(event.getMessage());
                MuleEvent toProcess = this.createEventToRoute(event, clonedMessage, mp);
                returnEvent = mp.process(toProcess);
                failed = returnEvent == null ? false : (msg = returnEvent.getMessage()) == null || this.failureExpressionFilter.accept(msg);
            }
            catch (Exception ex) {
                failed = true;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            throw new CouldNotRouteOutboundMessageException(event, this);
        }
        return returnEvent;
    }

    public boolean isMatch(MuleMessage message) throws MuleException {
        return true;
    }

    public void setFailureExpression(String failureExpression) {
        this.failureExpression = failureExpression;
    }
}

