/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

public class EqualsUtil {
    private static boolean isInitialized;
    private static boolean isHibernateInClasspath;
    private static Class<?> hibernateProxyClass;

    private EqualsUtil() {
    }

    @Deprecated
    public static boolean equals(Object thisObject, Object otherObject) {
        if (thisObject == null || otherObject == null) {
            return false;
        }
        if (EqualsUtil.isProxy(otherObject)) {
            return otherObject.equals(thisObject);
        }
        return otherObject == thisObject;
    }

    private static boolean isProxy(Object otherObject) {
        boolean isProxy = false;
        if (!isInitialized) {
            EqualsUtil.initializeHibernateProxyClass();
        }
        if (isHibernateInClasspath) {
            return hibernateProxyClass.isAssignableFrom(otherObject.getClass());
        }
        return isProxy;
    }

    private static synchronized void initializeHibernateProxyClass() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            hibernateProxyClass = classLoader.loadClass("org.hibernate.proxy.HibernateProxy");
        }
        catch (ClassNotFoundException e) {
            isHibernateInClasspath = false;
        }
        isInitialized = true;
    }

    static {
        isHibernateInClasspath = true;
    }
}

